/*
 * Decompiled with CFR 0.152.
 */
package de.ec.sql;

import de.ec.sql.BeforeGroupBy;
import de.ec.sql.BeforeJoin;
import de.ec.sql.BeforeOrderBy;
import de.ec.sql.BeforeWhere;
import de.ec.sql.Conditionable;
import de.ec.sql.Query;
import de.ec.sql.QueryBuilder;
import de.ec.sql.QueryOptions;
import de.ec.sql.QueryPart;
import de.ec.sql.QueryUtils;
import de.ec.sql.StringJoiner;

public class Join
extends Conditionable<Join>
implements QueryBuilder,
BeforeJoin,
BeforeWhere,
BeforeGroupBy,
BeforeOrderBy {
    private BeforeJoin builder;
    private final JoinMode joinMode;
    private Query query;
    private String name;
    private String sql;

    protected Join(BeforeJoin builder) {
        this(builder, JoinMode.INNER_JOIN);
    }

    protected Join(BeforeJoin builder, JoinMode joinMode) {
        this.builder = builder;
        this.joinMode = joinMode;
    }

    public Join subquery(Query query, String name) {
        this.query = query;
        this.name = name;
        return this;
    }

    public Join table(String name) {
        this.query = null;
        this.name = name;
        return this;
    }

    public Conditionable<Join> on() {
        return this;
    }

    @Override
    public String string(QueryOptions options) {
        StringJoiner strings = new StringJoiner();
        if (this.builder != null) {
            strings.add(this.builder.string(options));
        }
        if (this.sql != null) {
            strings.add(this.sql);
        } else if (this.name != null) {
            strings.add(options.newLine());
            strings.add(options.padCased(this.joinMode.string(options)));
            if (this.query != null) {
                strings.add(" ");
                strings.add(this.query.string(options));
            }
            strings.add(" ");
            strings.add(QueryUtils.splitName(options, this.name).string(options));
            String condition = super.string(options);
            if (condition != null) {
                strings.add(" ");
                strings.add(options.cased("ON"));
                strings.add(" ");
                strings.add(condition);
            }
        }
        return strings.toString();
    }

    protected Join builder(BeforeJoin builder) {
        this.builder = builder;
        return this;
    }

    protected Join query(Query query) {
        this.query = query;
        return this;
    }

    protected Join name(String name) {
        this.name = name;
        return this;
    }

    protected Join sql(String sql) {
        this.sql = sql;
        return this;
    }

    public static enum JoinMode implements QueryPart
    {
        INNER_JOIN("INNER JOIN"),
        OUTER_JOIN("OUTER JOIN"),
        LEFT_JOIN("LEFT JOIN"),
        RIGHT_JOIN("RIGHT JOIN"),
        CROSS_JOIN("CROSS JOIN");

        private final String string;

        private JoinMode(String string2) {
            this.string = string2;
        }

        @Override
        public String string(QueryOptions options) {
            return options.cased(this.string);
        }
    }
}

