/*
 * Decompiled with CFR 0.152.
 */
package de.ec.sql;

import de.ec.sql.BeforeOrderBy;
import de.ec.sql.OrderByTerm;
import de.ec.sql.QueryBuilder;
import de.ec.sql.QueryOptions;
import de.ec.sql.StringJoiner;
import java.util.ArrayList;
import java.util.List;

public class OrderBy
implements QueryBuilder {
    private BeforeOrderBy builder;
    private final List<OrderByTerm> orderByTerms = new ArrayList<OrderByTerm>();
    private String sql;

    protected OrderBy(BeforeOrderBy builder) {
        this.builder = builder;
    }

    public OrderBy column(String name, boolean ascending) {
        this.orderByTerms.add(new OrderByTerm(name, ascending));
        return this;
    }

    public OrderBy column(String name) {
        if (name != null) {
            String nameUpper = name.toUpperCase().trim();
            boolean ascending = true;
            if (nameUpper.endsWith(" DESC")) {
                ascending = false;
                name = name.replaceAll("\\s+[Dd][Ee][Ss][Cc]\\s*$", "");
            } else {
                name = name.replaceAll("\\s+[Aa][Ss][Cc]\\s*$", "");
            }
            String schema = null;
            if (name.contains(".")) {
                String[] parts = name.split("\\.");
                schema = parts[0];
                name = parts[1];
            }
            this.orderByTerms.add(new OrderByTerm(schema, name, ascending));
        }
        return this;
    }

    public OrderBy columns(String ... names) {
        if (names != null) {
            for (String name : names) {
                this.column(name);
            }
        }
        return this;
    }

    public OrderBy asc(String name) {
        return this.column(name, true);
    }

    public OrderBy desc(String name) {
        return this.column(name, false);
    }

    @Override
    public String string() {
        return this.string(QueryOptions.DEFAULT_OPTIONS);
    }

    @Override
    public String string(QueryOptions options) {
        StringJoiner strings = new StringJoiner();
        if (this.builder != null) {
            strings.add(this.builder.string(options));
        }
        if (this.sql != null) {
            strings.add(this.sql);
        } else {
            StringJoiner orderStrings = new StringJoiner();
            for (OrderByTerm orderByTerm : this.orderByTerms) {
                orderStrings.add(orderByTerm.string(options));
            }
            if (!orderStrings.isEmpty()) {
                strings.add(options.newLine());
                strings.add(options.padCased("ORDER BY"));
                strings.add(" ");
                strings.add(orderStrings.toString(", "));
            }
        }
        return strings.toString();
    }

    public OrderBy() {
    }

    protected OrderBy builder(BeforeOrderBy builder) {
        this.builder = builder;
        return this;
    }

    protected OrderBy sql(String sql) {
        this.sql = sql;
        return this;
    }
}

