/*
 * Decompiled with CFR 0.152.
 */
package de.ec.sql;

import de.ec.sql.QueryBuilder;
import de.ec.sql.QueryOptions;
import de.ec.sql.QueryPart;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query
implements QueryBuilder {
    private static final Logger log = LoggerFactory.getLogger(Query.class);
    private QueryOptions options;
    private final QueryPart builder;

    Query(QueryPart builder) {
        this.builder = builder;
    }

    public String toString() {
        return this.string();
    }

    @Override
    public String string(QueryOptions options) {
        return this.builder.string(this.safeOptions(options));
    }

    public Query options(QueryOptions options) {
        if (options != null) {
            options.query(this);
        }
        this.options = options;
        return this;
    }

    public PreparedStatement prepare(Connection connection) throws SQLException {
        return this.prepare(connection, this.safeOptions(this.options));
    }

    public PreparedStatement prepare(Connection connection, QueryOptions options) throws SQLException {
        options = this.safeOptions(options).prepare(true);
        String sql = this.string(options);
        if (options.sqlPostprocessor() != null) {
            sql = options.sqlPostprocessor().process(sql, connection);
        }
        log.info("Query preparation\n  \u250c Query     : " + sql + "\n  \u2514 Parameters: [" + options.preparedValuesString() + "]");
        PreparedStatement stmt = options.returnGeneratedKeys() ? connection.prepareStatement(sql, 1) : connection.prepareStatement(sql);
        stmt.setFetchSize(options.fetchSize());
        if (options.stmtPostprocessor() != null) {
            stmt = options.stmtPostprocessor().process(stmt, connection);
        }
        int index = 1;
        for (Object value : options.preparedValues()) {
            if (options.valueConverter() != null) {
                value = options.valueConverter().apply(value);
            }
            stmt.setObject(index++, value);
        }
        return stmt;
    }

    public String preparedString() {
        return this.preparedString(this.safeOptions(this.options));
    }

    public String preparedString(QueryOptions options) {
        return this.string(this.safeOptions(options));
    }

    private QueryOptions safeOptions(QueryOptions options) {
        options = options == null ? QueryOptions.DEFAULT_OPTIONS : options;
        return options.copy().query(this);
    }

    @Override
    public Query query() {
        return this;
    }

    protected QueryPart getBuilder() {
        return this.builder;
    }

    public QueryOptions options() {
        return this.options;
    }
}

