/*
 * Decompiled with CFR 0.152.
 */
package de.ec.sql;

import de.ec.sql.Name;
import de.ec.sql.PostProcessor;
import de.ec.sql.Query;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class QueryOptions {
    public static int FETCH_ALL = 0;
    static QueryOptions DEFAULT_OPTIONS = new QueryOptions();
    private int padLength = "SELECT".length();
    private boolean splitNames = true;
    private boolean pretty = true;
    private boolean indent = true;
    private boolean uppercase = true;
    private boolean backticks = false;
    private char quoteStartChar = (char)34;
    private char quoteEndChar = (char)34;
    private String dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private PostProcessor<String> sqlPostprocessor = null;
    private PostProcessor<PreparedStatement> stmtPostprocessor = null;
    private Function<Object, Object> valueConverter = null;
    private boolean returnGeneratedKeys = false;
    private int fetchSize = FETCH_ALL;
    private boolean escapeKeywords = false;
    private int indentLevel = 0;
    private boolean prepare;
    private final List<Object> preparedValues = new ArrayList<Object>();
    private Query query;

    void addPreparedValue(Object value) {
        this.preparedValues.add(value);
    }

    String indentString() {
        if (this.pretty && this.indent) {
            return StringUtils.repeat((char)' ', (int)(this.indentLevel * this.padLength + (this.indentLevel == 0 ? 0 : 1)));
        }
        return "";
    }

    String newLine() {
        return this.pretty ? "\n" + this.indentString() : " ";
    }

    String padCased(String keyword) {
        if (this.pretty && keyword != null) {
            int length = Math.max(0, this.padLength - keyword.split("\\s+")[0].length());
            return StringUtils.leftPad((String)"", (int)length) + this.cased(keyword);
        }
        return this.cased(keyword);
    }

    String ticked(String string) {
        if (string == null) {
            return null;
        }
        return this.backticks || this.escapeKeywords && Name.isKeyword(string) ? this.quoteStartChar + string + this.quoteEndChar : string;
    }

    String cased(String string) {
        if (string == null) {
            return null;
        }
        return this.uppercase ? string.toUpperCase() : string.toLowerCase();
    }

    QueryOptions copy() {
        return new QueryOptions().padLength(this.padLength).splitNames(this.splitNames).pretty(this.pretty).indent(this.indent).uppercase(this.uppercase).backticks(this.backticks).quoteStartChar(this.quoteStartChar).quoteEndChar(this.quoteEndChar).dateFormat(this.dateFormat).sqlPostprocessor(this.sqlPostprocessor).stmtPostprocessor(this.stmtPostprocessor).valueConverter(this.valueConverter).returnGeneratedKeys(this.returnGeneratedKeys).fetchSize(this.fetchSize).escapeKeywords(this.escapeKeywords).indentLevel(this.indentLevel);
    }

    String preparedValuesString() {
        StringBuilder sb = new StringBuilder();
        int index = 1;
        String prefix = "";
        for (Object value : this.preparedValues) {
            sb.append(prefix).append(index++).append(": ").append(value.toString());
            prefix = ", ";
        }
        return sb.toString();
    }

    public QueryOptions fetchAll() {
        return this.fetchSize(FETCH_ALL);
    }

    public QueryOptions fetchFirst() {
        return this.fetchSize(1);
    }

    public static QueryOptions getDefaultOptions() {
        return DEFAULT_OPTIONS.copy();
    }

    public static void setDefaultOptions(QueryOptions options) {
        DEFAULT_OPTIONS = options.copy();
    }

    public int padLength() {
        return this.padLength;
    }

    public boolean splitNames() {
        return this.splitNames;
    }

    public boolean pretty() {
        return this.pretty;
    }

    public boolean indent() {
        return this.indent;
    }

    public boolean uppercase() {
        return this.uppercase;
    }

    public boolean backticks() {
        return this.backticks;
    }

    public char quoteStartChar() {
        return this.quoteStartChar;
    }

    public char quoteEndChar() {
        return this.quoteEndChar;
    }

    public String dateFormat() {
        return this.dateFormat;
    }

    public PostProcessor<String> sqlPostprocessor() {
        return this.sqlPostprocessor;
    }

    public PostProcessor<PreparedStatement> stmtPostprocessor() {
        return this.stmtPostprocessor;
    }

    public Function<Object, Object> valueConverter() {
        return this.valueConverter;
    }

    public boolean returnGeneratedKeys() {
        return this.returnGeneratedKeys;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public boolean escapeKeywords() {
        return this.escapeKeywords;
    }

    public Query query() {
        return this.query;
    }

    public QueryOptions padLength(int padLength) {
        this.padLength = padLength;
        return this;
    }

    public QueryOptions splitNames(boolean splitNames) {
        this.splitNames = splitNames;
        return this;
    }

    public QueryOptions pretty(boolean pretty) {
        this.pretty = pretty;
        return this;
    }

    public QueryOptions indent(boolean indent) {
        this.indent = indent;
        return this;
    }

    public QueryOptions uppercase(boolean uppercase) {
        this.uppercase = uppercase;
        return this;
    }

    public QueryOptions backticks(boolean backticks) {
        this.backticks = backticks;
        return this;
    }

    public QueryOptions quoteStartChar(char quoteStartChar) {
        this.quoteStartChar = quoteStartChar;
        return this;
    }

    public QueryOptions quoteEndChar(char quoteEndChar) {
        this.quoteEndChar = quoteEndChar;
        return this;
    }

    public QueryOptions dateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public QueryOptions sqlPostprocessor(PostProcessor<String> sqlPostprocessor) {
        this.sqlPostprocessor = sqlPostprocessor;
        return this;
    }

    public QueryOptions stmtPostprocessor(PostProcessor<PreparedStatement> stmtPostprocessor) {
        this.stmtPostprocessor = stmtPostprocessor;
        return this;
    }

    public QueryOptions valueConverter(Function<Object, Object> valueConverter) {
        this.valueConverter = valueConverter;
        return this;
    }

    public QueryOptions returnGeneratedKeys(boolean returnGeneratedKeys) {
        this.returnGeneratedKeys = returnGeneratedKeys;
        return this;
    }

    public QueryOptions fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public QueryOptions escapeKeywords(boolean escapeKeywords) {
        this.escapeKeywords = escapeKeywords;
        return this;
    }

    public QueryOptions query(Query query) {
        this.query = query;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryOptions)) {
            return false;
        }
        QueryOptions other = (QueryOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.padLength() != other.padLength()) {
            return false;
        }
        if (this.splitNames() != other.splitNames()) {
            return false;
        }
        if (this.pretty() != other.pretty()) {
            return false;
        }
        if (this.indent() != other.indent()) {
            return false;
        }
        if (this.uppercase() != other.uppercase()) {
            return false;
        }
        if (this.backticks() != other.backticks()) {
            return false;
        }
        if (this.quoteStartChar() != other.quoteStartChar()) {
            return false;
        }
        if (this.quoteEndChar() != other.quoteEndChar()) {
            return false;
        }
        String this$dateFormat = this.dateFormat();
        String other$dateFormat = other.dateFormat();
        if (this$dateFormat == null ? other$dateFormat != null : !this$dateFormat.equals(other$dateFormat)) {
            return false;
        }
        PostProcessor<String> this$sqlPostprocessor = this.sqlPostprocessor();
        PostProcessor<String> other$sqlPostprocessor = other.sqlPostprocessor();
        if (this$sqlPostprocessor == null ? other$sqlPostprocessor != null : !this$sqlPostprocessor.equals(other$sqlPostprocessor)) {
            return false;
        }
        PostProcessor<PreparedStatement> this$stmtPostprocessor = this.stmtPostprocessor();
        PostProcessor<PreparedStatement> other$stmtPostprocessor = other.stmtPostprocessor();
        if (this$stmtPostprocessor == null ? other$stmtPostprocessor != null : !this$stmtPostprocessor.equals(other$stmtPostprocessor)) {
            return false;
        }
        Function<Object, Object> this$valueConverter = this.valueConverter();
        Function<Object, Object> other$valueConverter = other.valueConverter();
        if (this$valueConverter == null ? other$valueConverter != null : !this$valueConverter.equals(other$valueConverter)) {
            return false;
        }
        if (this.returnGeneratedKeys() != other.returnGeneratedKeys()) {
            return false;
        }
        if (this.fetchSize() != other.fetchSize()) {
            return false;
        }
        if (this.escapeKeywords() != other.escapeKeywords()) {
            return false;
        }
        if (this.indentLevel() != other.indentLevel()) {
            return false;
        }
        if (this.prepare() != other.prepare()) {
            return false;
        }
        List<Object> this$preparedValues = this.preparedValues();
        List<Object> other$preparedValues = other.preparedValues();
        if (this$preparedValues == null ? other$preparedValues != null : !((Object)this$preparedValues).equals(other$preparedValues)) {
            return false;
        }
        Query this$query = this.query();
        Query other$query = other.query();
        return !(this$query == null ? other$query != null : !this$query.equals(other$query));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.padLength();
        result = result * 59 + (this.splitNames() ? 79 : 97);
        result = result * 59 + (this.pretty() ? 79 : 97);
        result = result * 59 + (this.indent() ? 79 : 97);
        result = result * 59 + (this.uppercase() ? 79 : 97);
        result = result * 59 + (this.backticks() ? 79 : 97);
        result = result * 59 + this.quoteStartChar();
        result = result * 59 + this.quoteEndChar();
        String $dateFormat = this.dateFormat();
        result = result * 59 + ($dateFormat == null ? 43 : $dateFormat.hashCode());
        PostProcessor<String> $sqlPostprocessor = this.sqlPostprocessor();
        result = result * 59 + ($sqlPostprocessor == null ? 43 : $sqlPostprocessor.hashCode());
        PostProcessor<PreparedStatement> $stmtPostprocessor = this.stmtPostprocessor();
        result = result * 59 + ($stmtPostprocessor == null ? 43 : $stmtPostprocessor.hashCode());
        Function<Object, Object> $valueConverter = this.valueConverter();
        result = result * 59 + ($valueConverter == null ? 43 : $valueConverter.hashCode());
        result = result * 59 + (this.returnGeneratedKeys() ? 79 : 97);
        result = result * 59 + this.fetchSize();
        result = result * 59 + (this.escapeKeywords() ? 79 : 97);
        result = result * 59 + this.indentLevel();
        result = result * 59 + (this.prepare() ? 79 : 97);
        List<Object> $preparedValues = this.preparedValues();
        result = result * 59 + ($preparedValues == null ? 43 : ((Object)$preparedValues).hashCode());
        Query $query = this.query();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        return result;
    }

    public String toString() {
        return "QueryOptions(padLength=" + this.padLength() + ", splitNames=" + this.splitNames() + ", pretty=" + this.pretty() + ", indent=" + this.indent() + ", uppercase=" + this.uppercase() + ", backticks=" + this.backticks() + ", quoteStartChar=" + this.quoteStartChar() + ", quoteEndChar=" + this.quoteEndChar() + ", dateFormat=" + this.dateFormat() + ", sqlPostprocessor=" + this.sqlPostprocessor() + ", stmtPostprocessor=" + this.stmtPostprocessor() + ", valueConverter=" + this.valueConverter() + ", returnGeneratedKeys=" + this.returnGeneratedKeys() + ", fetchSize=" + this.fetchSize() + ", escapeKeywords=" + this.escapeKeywords() + ", indentLevel=" + this.indentLevel() + ", prepare=" + this.prepare() + ", preparedValues=" + this.preparedValues() + ", query=" + this.query() + ")";
    }

    int indentLevel() {
        return this.indentLevel;
    }

    QueryOptions indentLevel(int indentLevel) {
        this.indentLevel = indentLevel;
        return this;
    }

    boolean prepare() {
        return this.prepare;
    }

    QueryOptions prepare(boolean prepare) {
        this.prepare = prepare;
        return this;
    }

    List<Object> preparedValues() {
        return this.preparedValues;
    }
}

