/*
 * Decompiled with CFR 0.152.
 */
package de.ec.sql;

import de.ec.sql.BeforeFrom;
import de.ec.sql.BeforeSelect;
import de.ec.sql.QueryOptions;
import de.ec.sql.QueryPart;
import de.ec.sql.QueryUtils;
import de.ec.sql.StringJoiner;
import java.util.ArrayList;
import java.util.List;

public class Select
implements QueryPart,
BeforeFrom {
    private final List<String> columns = new ArrayList<String>();
    private boolean distinct = false;
    private boolean all = false;
    private BeforeSelect builder;
    private String sql;

    public Select(String ... columns) {
        this.columns(columns);
    }

    protected Select(BeforeSelect builder) {
        this.builder = builder;
    }

    public Select distinct() {
        this.distinct = true;
        this.all = false;
        return this;
    }

    public Select all() {
        this.distinct = false;
        this.all = true;
        return this;
    }

    public Select column(String column) {
        this.columns.add(column);
        return this;
    }

    public Select columns(String ... columns) {
        if (columns != null) {
            for (String column : columns) {
                this.columns.add(column);
            }
        }
        return this;
    }

    @Override
    public String string(QueryOptions options) {
        StringJoiner strings = new StringJoiner();
        if (this.builder != null) {
            strings.add(this.builder.string(options));
            strings.add(options.newLine());
        }
        if (this.sql != null) {
            strings.add(this.sql);
        } else {
            strings.add(options.padCased("SELECT"));
            if (this.distinct) {
                strings.add(" ");
                strings.add(options.cased("DISTINCT"));
            } else if (this.all) {
                strings.add(" ");
                strings.add(options.cased("ALL"));
            }
            if (this.columns.isEmpty()) {
                strings.add(" *");
            } else {
                StringJoiner columnsStrings = new StringJoiner();
                for (String column : this.columns) {
                    columnsStrings.add(QueryUtils.splitName(options, column).string(options));
                }
                strings.add(" ");
                strings.add(columnsStrings.toString(", "));
            }
        }
        return strings.toString();
    }

    public Select() {
    }

    protected Select distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    protected Select all(boolean all) {
        this.all = all;
        return this;
    }

    protected Select builder(BeforeSelect builder) {
        this.builder = builder;
        return this;
    }

    protected Select sql(String sql) {
        this.sql = sql;
        return this;
    }
}

