/*
 * Decompiled with CFR 0.152.
 */
package de.ec.sql;

import de.ec.sql.BeforeUpdate;
import de.ec.sql.BeforeWhere;
import de.ec.sql.QueryBuilder;
import de.ec.sql.QueryOptions;
import de.ec.sql.QueryPart;
import de.ec.sql.QueryUtils;
import de.ec.sql.StringJoiner;
import de.ec.sql.Table;
import de.ec.sql.UpdateValue;
import de.ec.sql.ValueHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Update
implements QueryBuilder,
BeforeWhere {
    private UpdateType updateType = UpdateType.UPDATE;
    private BeforeUpdate builder;
    private final String table;
    private final List<UpdateValue> updateValues = new ArrayList<UpdateValue>();
    private String sql;

    public Update(String table) {
        this.table = table;
    }

    public Update(Table table) {
        this(table.tableName());
    }

    protected Update(BeforeUpdate builder, String table) {
        this(table);
        this.builder = builder;
    }

    private Update setType(UpdateType updateType) {
        this.updateType = updateType;
        return this;
    }

    public Update orRollback() {
        return this.setType(UpdateType.UPDATE_OR_ROLLBACK);
    }

    public Update orAbort() {
        return this.setType(UpdateType.UPDATE_OR_ABORT);
    }

    public Update orFail() {
        return this.setType(UpdateType.UPDATE_OR_FAIL);
    }

    public Update orReplace() {
        return this.setType(UpdateType.UPDATE_OR_REPLACE);
    }

    public Update orIgnore() {
        return this.setType(UpdateType.UPDATE_OR_IGNORE);
    }

    public UpdateValue set(String column) {
        UpdateValue updateValue = new UpdateValue(this, column);
        this.updateValues.add(updateValue);
        return updateValue;
    }

    public Update set(String column, Object value) {
        return this.set(column).value(value);
    }

    public Update set(ValueHolder values) {
        for (Map.Entry entry : values) {
            this.set((String)entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public String string(QueryOptions options) {
        StringJoiner strings = new StringJoiner();
        if (this.builder != null) {
            strings.add(this.builder.string(options));
            strings.add(options.newLine());
        }
        if (this.sql != null) {
            strings.add(this.sql);
        } else {
            strings.add(options.padCased(this.updateType.string(options)));
            strings.add(" ");
            strings.add(this.table);
            strings.add(options.newLine());
            strings.add(options.padCased("SET"));
            strings.add(" ");
            StringJoiner sets = new StringJoiner();
            for (UpdateValue updateValue : this.updateValues) {
                String column = QueryUtils.splitName(options, updateValue.getColumn()).string(options) + " = ";
                if (updateValue.isExpression()) {
                    column = column + updateValue.getValue().toString();
                } else if (options.prepare()) {
                    column = column + "?";
                    options.addPreparedValue(updateValue.getValue());
                } else {
                    column = column + QueryUtils.valueToString(options, updateValue.getValue());
                }
                sets.add(column);
            }
            strings.add(sets.toString(", "));
        }
        return strings.toString();
    }

    protected Update updateType(UpdateType updateType) {
        this.updateType = updateType;
        return this;
    }

    protected Update builder(BeforeUpdate builder) {
        this.builder = builder;
        return this;
    }

    protected Update sql(String sql) {
        this.sql = sql;
        return this;
    }

    protected static enum UpdateType implements QueryPart
    {
        UPDATE("UPDATE"),
        UPDATE_OR_ROLLBACK("UPDATE OR ROLLBACK"),
        UPDATE_OR_ABORT("UPDATE OR ABORT"),
        UPDATE_OR_REPLACE("UPDATE OR REPLACE"),
        UPDATE_OR_FAIL("UPDATE OR FAIL"),
        UPDATE_OR_IGNORE("UPDATE OR IGNORE");

        private String string;

        private UpdateType(String string2) {
            this.string = string2;
        }

        @Override
        public String string(QueryOptions options) {
            return options.cased(this.string);
        }
    }
}

