/*
 * Decompiled with CFR 0.152.
 */
package de.ec.sql;

import de.ec.sql.BeforeDelete;
import de.ec.sql.BeforeInsert;
import de.ec.sql.BeforeSelect;
import de.ec.sql.BeforeUpdate;
import de.ec.sql.BeforeWith;
import de.ec.sql.Query;
import de.ec.sql.QueryBuilder;
import de.ec.sql.QueryOptions;
import de.ec.sql.QueryPart;
import de.ec.sql.StringJoiner;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class With
implements QueryPart,
BeforeWith,
BeforeSelect,
BeforeUpdate,
BeforeDelete,
BeforeInsert {
    private BeforeWith builder;
    private final String name;
    private final List<String> columns = new ArrayList<String>();
    private Query query;
    private boolean recursive;
    private String sql;

    public With(String name) {
        this.name = name;
    }

    protected With(BeforeWith builder, String name) {
        this.name = name;
        this.builder = builder;
    }

    public With recursive() {
        this.recursive = true;
        return this;
    }

    public With column(String column) {
        this.columns.add(column);
        return this;
    }

    public With columns(String ... columns) {
        for (String column : columns) {
            this.columns.add(column);
        }
        return this;
    }

    public With as(Query query) {
        this.query = query;
        return this;
    }

    public With as(QueryBuilder builder) {
        return this.as(builder.query());
    }

    @Override
    public String string(QueryOptions options) {
        StringJoiner strings = new StringJoiner();
        if (this.builder == null) {
            if (this.sql == null) {
                strings.add(options.padCased("WITH"));
                if (this.recursive) {
                    strings.add(" ");
                    strings.add(options.cased("RECURSIVE"));
                }
            }
        } else {
            strings.add(options.newLine());
            strings.add(this.builder.string(options));
            strings.add(",");
        }
        if (this.sql != null) {
            strings.add(this.sql);
        } else {
            strings.add(" ");
            strings.add(this.name);
            if (!this.columns.isEmpty()) {
                strings.add(" (");
                strings.add(StringUtils.join(this.columns, (String)", "));
                strings.add(")");
            }
            strings.add(" ");
            strings.add(options.cased("AS"));
            strings.add(" (");
            QueryOptions subOptions = options.copy().indentLevel(options.indentLevel() + 1);
            strings.add(subOptions.newLine());
            strings.add(this.query.string(subOptions).trim());
            strings.add(")");
        }
        return strings.toString();
    }

    protected With builder(BeforeWith builder) {
        this.builder = builder;
        return this;
    }

    protected With query(Query query) {
        this.query = query;
        return this;
    }

    protected With recursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    protected With sql(String sql) {
        this.sql = sql;
        return this;
    }
}

