/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import com.github.eikecochu.sqlbuilder.ConditionValue;
import com.github.eikecochu.sqlbuilder.Conditionable;
import com.github.eikecochu.sqlbuilder.Expression;
import com.github.eikecochu.sqlbuilder.QueryBuilder;
import com.github.eikecochu.sqlbuilder.QueryOptions;
import com.github.eikecochu.sqlbuilder.QueryPart;
import com.github.eikecochu.sqlbuilder.QueryUtils;
import com.github.eikecochu.sqlbuilder.StringJoiner;
import com.github.eikecochu.sqlbuilder.StringUtils;
import java.util.Arrays;

public class ConditionPart<T extends Conditionable<T>>
implements QueryPart {
    private final Conditionable<T> conditionable;
    private final String name;
    private Object[] values;
    private Operator operator;
    private boolean not;
    private ConditionValue.ConditionValueType type;

    protected ConditionPart(Conditionable<T> conditionable, String name) {
        this.conditionable = conditionable;
        this.name = name;
    }

    public ConditionPart<T> not() {
        this.not = !this.not;
        return this;
    }

    public ConditionValue<T> eq() {
        return new ConditionValue(this, Operator.EQUALS);
    }

    public T eq(Object value) {
        return this.condition(Operator.EQUALS, ConditionValue.ConditionValueType.VALUE, value);
    }

    public T eqCol(String column) {
        return this.eq().col(column);
    }

    public T eqExpr(String expr, Object ... values) {
        return this.eq().expr(expr, values);
    }

    public ConditionValue<T> notEq() {
        return new ConditionValue(this, Operator.NOT_EQUALS);
    }

    public T notEq(Object value) {
        return this.condition(Operator.NOT_EQUALS, ConditionValue.ConditionValueType.VALUE, value);
    }

    public ConditionValue<T> ge() {
        return new ConditionValue(this, Operator.GE);
    }

    public T ge(Object value) {
        return this.condition(Operator.GE, ConditionValue.ConditionValueType.VALUE, value);
    }

    public ConditionValue<T> gt() {
        return new ConditionValue(this, Operator.GT);
    }

    public T gt(Object value) {
        return this.condition(Operator.GT, ConditionValue.ConditionValueType.VALUE, value);
    }

    public ConditionValue<T> le() {
        return new ConditionValue(this, Operator.LE);
    }

    public T le(Object value) {
        return this.condition(Operator.LE, ConditionValue.ConditionValueType.VALUE, value);
    }

    public ConditionValue<T> lt() {
        return new ConditionValue(this, Operator.LT);
    }

    public T lt(Object value) {
        return this.condition(Operator.LT, ConditionValue.ConditionValueType.VALUE, value);
    }

    public ConditionValue<T> like() {
        return new ConditionValue(this, Operator.LIKE);
    }

    public T like(Object value) {
        return this.condition(Operator.LIKE, ConditionValue.ConditionValueType.VALUE, value);
    }

    public ConditionValue<T> in() {
        return new ConditionValue(this, Operator.IN);
    }

    public T in(Object ... values) {
        return this.in().values(values);
    }

    public T in(Iterable<Object> values) {
        return this.in().values(values);
    }

    public ConditionValue.ConditionBiValue<T> between() {
        return new ConditionValue.ConditionBiValue(this, Operator.BETWEEN);
    }

    public T between(Object value1, Object value2) {
        return this.between().values(value1, value2);
    }

    public T isNull() {
        return this.condition(Operator.IS_NULL, ConditionValue.ConditionValueType.VALUE, null);
    }

    protected T condition(Operator operator, ConditionValue.ConditionValueType type, Object value) {
        Object[] objectArray;
        if (value == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = value;
        }
        return this.condition(operator, type, objectArray);
    }

    protected T condition(Operator operator, ConditionValue.ConditionValueType type, Object[] values) {
        this.values = values;
        this.operator = operator;
        this.type = type;
        return (T)this.conditionable;
    }

    @Override
    public String string(QueryOptions options) {
        StringJoiner strings = new StringJoiner();
        if (!(this.operator == Operator.IS_NULL || this.operator == Operator.IS_NOT_NULL || options.ignoreNull() || this.values != null && this.values.length != 0)) {
            this.operator = Operator.IS_NULL;
        }
        if (this.values != null && this.values.length > 0 || this.operator == Operator.IS_NULL || this.operator == Operator.IS_NOT_NULL) {
            if (this.not) {
                strings.add(options.cased("NOT"));
                strings.add(" ");
            }
            if (this.name != null) {
                strings.add(QueryUtils.splitName(options, this.name).string(options));
                strings.add(" ");
            }
            if (this.operator != null) {
                strings.add(this.operator.string(options));
            }
            if (this.operator != Operator.IS_NULL && this.operator != Operator.IS_NOT_NULL) {
                strings.add(" ");
                if (this.operator == Operator.BETWEEN) {
                    if (options.prepare()) {
                        strings.add("? AND ?");
                        options.addPreparedValue(this.values[0]);
                        options.addPreparedValue(this.values[1]);
                    } else {
                        strings.add(QueryUtils.valueToString(options, this.values[0]));
                        strings.add(" AND ");
                        strings.add(QueryUtils.valueToString(options, this.values[1]));
                    }
                } else if (this.operator == Operator.IN) {
                    strings.add("(");
                    if (options.prepare()) {
                        strings.add(QueryUtils.preparedInValues(this.values.length));
                        for (Object value : this.values) {
                            options.addPreparedValue(value);
                        }
                    } else {
                        strings.add(StringUtils.join(QueryUtils.valuesToStrings(options, this.values), ", "));
                    }
                    strings.add(")");
                } else if (this.type != null) {
                    switch (this.type) {
                        case EXPRESSION: {
                            Expression expression;
                            if (this.values.length == 1) {
                                expression = new Expression(this.values[0].toString(), new Object[0]);
                            } else {
                                Object[] subValues = Arrays.copyOfRange(this.values, 1, this.values.length);
                                expression = new Expression(this.values[0].toString(), subValues);
                            }
                            strings.add(expression.string(options));
                            break;
                        }
                        case COLUMN: {
                            strings.add(QueryUtils.splitName(options, this.values[0].toString()).string(options));
                            break;
                        }
                        case ALL: 
                        case ANY: {
                            strings.add(this.type.string(options));
                            strings.add(" (");
                            QueryOptions subOptions = options.copy().indentLevel(options.indentLevel() + 1);
                            strings.add(subOptions.newLine(true));
                            strings.add(((QueryBuilder)this.values[0]).string(subOptions).trim());
                            strings.add(")");
                            break;
                        }
                        default: {
                            if (options.prepare()) {
                                strings.add("?");
                                options.addPreparedValue(this.values[0]);
                                break;
                            }
                            strings.add(QueryUtils.valueToString(options, this.values[0]));
                        }
                    }
                }
            }
        }
        return strings.toString();
    }

    public String toString() {
        return "ConditionPart(conditionable=" + this.getConditionable() + ", name=" + this.getName() + ", values=" + Arrays.deepToString(this.getValues()) + ", operator=" + this.getOperator() + ", not=" + this.isNot() + ", type=" + this.getType() + ")";
    }

    protected Conditionable<T> getConditionable() {
        return this.conditionable;
    }

    protected String getName() {
        return this.name;
    }

    protected Object[] getValues() {
        return this.values;
    }

    protected Operator getOperator() {
        return this.operator;
    }

    protected boolean isNot() {
        return this.not;
    }

    protected ConditionValue.ConditionValueType getType() {
        return this.type;
    }

    public static enum Operator implements QueryPart
    {
        EQUALS("="),
        NOT_EQUALS("<>"),
        LIKE("LIKE"),
        IN("IN"),
        IS_NULL("IS NULL"),
        IS_NOT_NULL("IS NOT NULL"),
        GE(">="),
        GT(">"),
        LE("<="),
        LT("<="),
        BETWEEN("BETWEEN");

        private final String string;

        private Operator(String string2) {
            this.string = string2;
        }

        @Override
        public String string(QueryOptions options) {
            return options.cased(this.string);
        }

        public String toString() {
            return "ConditionPart.Operator." + this.name() + "(string=" + this.string + ")";
        }
    }
}

