/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import com.github.eikecochu.sqlbuilder.Condition;
import com.github.eikecochu.sqlbuilder.ConditionPart;
import com.github.eikecochu.sqlbuilder.NestedCondition;
import com.github.eikecochu.sqlbuilder.QueryOptions;
import com.github.eikecochu.sqlbuilder.QueryPart;
import com.github.eikecochu.sqlbuilder.QueryPartImpl;
import com.github.eikecochu.sqlbuilder.StringJoiner;
import com.github.eikecochu.sqlbuilder.ValueHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public abstract class Conditionable<T extends Conditionable<T>>
extends QueryPartImpl<T> {
    private final List<QueryPart> parts = new ArrayList<QueryPart>();
    private final Conditionable<T> conditionable = this;

    public Conditionable() {
        this(null);
    }

    protected Conditionable(QueryPart parent) {
        super(parent);
    }

    public T values(ValueHolder values) {
        if (values != null) {
            for (Map.Entry value : values) {
                this.col((String)value.getKey(), value.getValue());
            }
        }
        return (T)this;
    }

    public ConditionPart<T> col(String name) {
        ConditionPart<T> part = new ConditionPart<T>(this.conditionable(), name);
        this.addPart(part);
        return part;
    }

    public T col(String name, Object value) {
        return this.col(name).eq(value);
    }

    public T col(String name, Object ... values) {
        return this.col(name).in(values);
    }

    public T group(Condition group) {
        return this.addPart(group);
    }

    public NestedCondition<T> groupStart() {
        NestedCondition group = new NestedCondition(this);
        this.addPart(group);
        return group;
    }

    public T and() {
        return this.op(Operator.AND);
    }

    public T or() {
        return this.op(Operator.OR);
    }

    T addPart(QueryPart part) {
        if (!this.parts.isEmpty() && !(this.parts.get(this.parts.size() - 1) instanceof Operator)) {
            this.and();
        }
        this.parts.add(part);
        return (T)this.conditionable;
    }

    private T op(Operator operator) {
        if (!this.parts.isEmpty() && this.parts.size() % 2 == 1) {
            this.parts.add(operator);
        }
        return (T)this;
    }

    private Conditionable<T> conditionable() {
        return this.conditionable;
    }

    @Override
    public String string(QueryOptions options) {
        StringJoiner strings = new StringJoiner();
        ArrayList<QueryPart> validParts = new ArrayList<QueryPart>(this.parts.size());
        boolean valueNext = true;
        for (QueryPart part : this.parts) {
            if (valueNext == !(part instanceof Operator)) {
                validParts.add(part);
            }
            valueNext = !valueNext;
        }
        ListIterator it = validParts.listIterator(validParts.size());
        while (it.hasPrevious() && it.previous() instanceof Operator) {
            it.remove();
        }
        if (validParts.isEmpty()) {
            return null;
        }
        String first = ((QueryPart)validParts.get(0)).string(options);
        boolean needsOp = false;
        if (first != null && !first.isEmpty()) {
            needsOp = true;
            strings.add(first);
        }
        for (int i = 1; i < validParts.size(); i += 2) {
            String op = ((QueryPart)validParts.get(i)).string(options);
            String val = ((QueryPart)validParts.get(i + 1)).string(options);
            if (needsOp) {
                if (op == null || op.isEmpty() || val == null || val.isEmpty()) continue;
                if (options.conditionOnNewline()) {
                    strings.add(options.newLine());
                    strings.add(options.padded(op));
                    strings.add(" ");
                } else {
                    strings.add(op);
                }
                strings.add(val);
                continue;
            }
            if (val == null || val.isEmpty()) continue;
            needsOp = true;
            strings.add(val);
        }
        return strings.toString(options.conditionOnNewline() ? "" : " ");
    }

    public String toString() {
        return "Conditionable(parts=" + this.getParts() + ", conditionable=" + this.getConditionable() + ")";
    }

    protected List<QueryPart> getParts() {
        return this.parts;
    }

    protected Conditionable<T> getConditionable() {
        return this.conditionable;
    }

    public static enum Operator implements QueryPart
    {
        AND("AND"),
        OR("OR");

        private final String string;

        private Operator(String string2) {
            this.string = string2;
        }

        @Override
        public String string(QueryOptions options) {
            return options.cased(this.string);
        }

        public String toString() {
            return "Conditionable.Operator." + this.name() + "(string=" + this.string + ")";
        }
    }
}

