/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import com.github.eikecochu.sqlbuilder.QueryOptions;
import com.github.eikecochu.sqlbuilder.QueryPart;
import com.github.eikecochu.sqlbuilder.QueryUtils;

public class Expression
implements QueryPart {
    private String expression;
    private Object[] values;

    public Expression(String expression, Object ... values) {
        this.expression = expression;
        this.values = values;
    }

    public String toString() {
        return this.string();
    }

    @Override
    public String string(QueryOptions options) {
        if ((options = this.safeOptions(options)).prepare()) {
            return this.preparedString(options);
        }
        return this.valueString(options);
    }

    public String preparedString(QueryOptions options) {
        boolean prepare;
        options = this.safeOptions(options);
        String result = this.expression;
        boolean bl = prepare = options != null && options.prepare();
        if (this.values != null && this.values.length > 0 && !result.contains("(")) {
            StringBuilder params = new StringBuilder();
            String defaultPlaceholder = options.defaultPlaceholder();
            boolean hasPlaceholder = defaultPlaceholder != null && !defaultPlaceholder.isEmpty();
            boolean defaults = false;
            String delim = "";
            for (Object value : this.values) {
                if (value == null) {
                    defaults = true;
                    if (hasPlaceholder) {
                        params.append(delim).append(defaultPlaceholder);
                    }
                } else {
                    if (defaults && !hasPlaceholder) {
                        throw new RuntimeException("middle parameter null");
                    }
                    params.append(delim).append("?");
                    if (prepare) {
                        options.addPreparedValue(value);
                    }
                }
                delim = ", ";
            }
            result = result + "(" + params.toString() + ")";
        }
        return result;
    }

    public String valueString(QueryOptions options) {
        options = this.safeOptions(options);
        String result = this.expression;
        if (this.values != null && this.values.length > 0 && !result.contains("(")) {
            StringBuilder params = new StringBuilder();
            String defaultPlaceholder = options.defaultPlaceholder();
            boolean hasPlaceholder = defaultPlaceholder != null && !defaultPlaceholder.isEmpty();
            boolean defaults = false;
            String delim = "";
            for (Object value : this.values) {
                if (value == null) {
                    defaults = true;
                    if (hasPlaceholder) {
                        params.append(delim).append(defaultPlaceholder);
                    }
                } else {
                    if (defaults && !hasPlaceholder) {
                        throw new RuntimeException("middle parameter null");
                    }
                    params.append(delim).append(QueryUtils.valueToString(options, value));
                }
                delim = ", ";
            }
            result = result + "(" + params.toString() + ")";
        }
        return result;
    }

    private QueryOptions safeOptions(QueryOptions options) {
        return options == null ? QueryOptions.getDefaultOptions() : options;
    }

    public Expression() {
    }

    public String expression() {
        return this.expression;
    }

    public Object[] values() {
        return this.values;
    }

    public Expression expression(String expression) {
        this.expression = expression;
        return this;
    }

    public Expression values(Object[] values) {
        this.values = values;
        return this;
    }
}

