/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import com.github.eikecochu.sqlbuilder.BeforeInsert;
import com.github.eikecochu.sqlbuilder.BeforeSelect;
import com.github.eikecochu.sqlbuilder.InsertValue;
import com.github.eikecochu.sqlbuilder.QueryBuilder;
import com.github.eikecochu.sqlbuilder.QueryOptions;
import com.github.eikecochu.sqlbuilder.QueryPart;
import com.github.eikecochu.sqlbuilder.QueryPartImpl;
import com.github.eikecochu.sqlbuilder.QueryUtils;
import com.github.eikecochu.sqlbuilder.Select;
import com.github.eikecochu.sqlbuilder.StringJoiner;
import com.github.eikecochu.sqlbuilder.Table;
import com.github.eikecochu.sqlbuilder.ValueHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Insert
extends QueryPartImpl<Insert>
implements QueryBuilder,
BeforeSelect {
    private final String table;
    private InsertType insertType = InsertType.INSERT;
    private final List<InsertValue> insertValues = new ArrayList<InsertValue>();
    private boolean defaultValues = false;
    private boolean onlyValues = true;

    public Insert(String table) {
        this(null, table);
    }

    public Insert(Table table) {
        this(table.tableName());
    }

    protected Insert(BeforeInsert parent, String table) {
        super(parent);
        this.table = table;
    }

    public Insert replace() {
        return this.insertType(InsertType.REPLACE);
    }

    public Insert orReplace() {
        return this.insertType(InsertType.INSERT_OR_REPLACE);
    }

    public Insert orRollback() {
        return this.insertType(InsertType.INSERT_OR_ROLLBACK);
    }

    public Insert orAbort() {
        return this.insertType(InsertType.INSERT_OR_ABORT);
    }

    public Insert orFail() {
        return this.insertType(InsertType.INSERT_OR_FAIL);
    }

    public Insert orIgnore() {
        return this.insertType(InsertType.INSERT_OR_IGNORE);
    }

    @Override
    public Select select() {
        this.insertValues.clear();
        this.defaultValues = false;
        return BeforeSelect.super.select();
    }

    public InsertValue column(String column) {
        this.defaultValues = false;
        this.onlyValues = false;
        InsertValue insertValue = new InsertValue(this, column);
        this.insertValues.add(insertValue);
        return insertValue;
    }

    public Insert column(String column, Object value) {
        return this.column(column).value(value);
    }

    public Insert columns(ValueHolder values) {
        for (Map.Entry entry : values) {
            this.column((String)entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Insert value(Object value) {
        return this.column(null).value(value);
    }

    public Insert values(ValueHolder values) {
        for (Map.Entry entry : values) {
            this.value(entry.getValue());
        }
        return this;
    }

    public Insert defaults() {
        this.insertValues.clear();
        this.defaultValues = true;
        return this;
    }

    @Override
    public String string(QueryOptions options) {
        StringJoiner strings = new StringJoiner();
        if (this.parent() != null) {
            strings.add(this.parent().string(options));
        }
        if (strings.notEmpty()) {
            strings.add(options.newLine());
        }
        if (this.sql() != null) {
            strings.add(options.padded(this.sql()));
        } else {
            strings.add(options.padCased(this.insertType.string(options)));
            strings.add(" ");
            strings.add(this.table);
            if (this.defaultValues) {
                strings.add("DEFAULT VALUES");
            } else {
                if (!this.onlyValues) {
                    strings.add(" (");
                    StringJoiner columns = new StringJoiner();
                    for (InsertValue insertValue : this.insertValues) {
                        columns.add(QueryUtils.splitName(options, insertValue.getColumn()).string(options));
                    }
                    strings.add(columns.toString(", "));
                    strings.add(")");
                }
                strings.add(options.newLine());
                strings.add(options.padCased("VALUES"));
                int count = this.insertValues.get(0).getValues().size();
                for (int i = 0; i < count; ++i) {
                    if (i > 0) {
                        strings.add(options.newLine()).add(options.padCased(""));
                    }
                    strings.add(" (");
                    StringJoiner values = new StringJoiner();
                    for (InsertValue insertValue : this.insertValues) {
                        if (options.prepare()) {
                            values.add("?");
                            options.addPreparedValue(insertValue.getValues().get(i));
                            continue;
                        }
                        values.add(QueryUtils.valueToString(options, insertValue.getValues().get(i)));
                    }
                    strings.add(values.toString(", "));
                    strings.add(")");
                }
            }
        }
        return strings.toString();
    }

    public String toString() {
        return "Insert(table=" + this.table + ", insertType=" + this.insertType + ", insertValues=" + this.insertValues + ", defaultValues=" + this.defaultValues + ", onlyValues=" + this.onlyValues + ")";
    }

    protected Insert insertType(InsertType insertType) {
        this.insertType = insertType;
        return this;
    }

    protected Insert defaultValues(boolean defaultValues) {
        this.defaultValues = defaultValues;
        return this;
    }

    protected Insert onlyValues(boolean onlyValues) {
        this.onlyValues = onlyValues;
        return this;
    }

    private static enum InsertType implements QueryPart
    {
        INSERT("INSERT INTO"),
        REPLACE("REPLACE INTO"),
        INSERT_OR_REPLACE("INSERT OR REPLACE INTO"),
        INSERT_OR_ROLLBACK("INSERT OR ROLLBACK INTO"),
        INSERT_OR_ABORT("INSERT OR ABORT INTO"),
        INSERT_OR_FAIL("INSERT OR FAIL INTO"),
        INSERT_OR_IGNORE("INSERT OR IGNORE INTO");

        private final String string;

        private InsertType(String string2) {
            this.string = string2;
        }

        @Override
        public String string(QueryOptions options) {
            return options.cased(this.string);
        }

        public String toString() {
            return "Insert.InsertType." + this.name() + "(string=" + this.string + ")";
        }
    }
}

