/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import com.github.eikecochu.sqlbuilder.BeforeGroupBy;
import com.github.eikecochu.sqlbuilder.BeforeJoin;
import com.github.eikecochu.sqlbuilder.BeforeOrderBy;
import com.github.eikecochu.sqlbuilder.BeforeUnion;
import com.github.eikecochu.sqlbuilder.BeforeWhere;
import com.github.eikecochu.sqlbuilder.Conditionable;
import com.github.eikecochu.sqlbuilder.Query;
import com.github.eikecochu.sqlbuilder.QueryBuilder;
import com.github.eikecochu.sqlbuilder.QueryOptions;
import com.github.eikecochu.sqlbuilder.QueryPart;
import com.github.eikecochu.sqlbuilder.QueryUtils;
import com.github.eikecochu.sqlbuilder.StringJoiner;

public class Join
extends Conditionable<Join>
implements QueryBuilder,
BeforeJoin,
BeforeWhere,
BeforeGroupBy,
BeforeOrderBy,
BeforeUnion {
    private final JoinMode joinMode;
    private Query query;
    private String name;

    protected Join(BeforeJoin parent) {
        this(parent, JoinMode.INNER_JOIN);
    }

    protected Join(BeforeJoin parent, JoinMode joinMode) {
        super(parent);
        this.joinMode = joinMode;
    }

    public Join subquery(Query query, String name) {
        this.query = query;
        this.name = name;
        return this;
    }

    public Join table(String name) {
        this.query = null;
        this.name = name;
        return this;
    }

    public Conditionable<Join> on() {
        return this;
    }

    @Override
    public String string(QueryOptions options) {
        StringJoiner strings = new StringJoiner();
        if (this.parent() != null) {
            strings.add(this.parent().string(options));
        }
        if (strings.notEmpty()) {
            strings.add(options.newLine());
        }
        if (this.sql() != null) {
            strings.add(options.padded(this.sql()));
        } else if (this.name != null) {
            strings.add(options.padCased(this.joinMode.string(options)));
            if (this.query != null) {
                strings.add(" ");
                strings.add(this.query.string(options));
            }
            strings.add(" ");
            strings.add(QueryUtils.splitName(options, this.name).string(options));
            String condition = super.string(options);
            if (condition != null) {
                strings.add(" ");
                strings.add(options.cased("ON"));
                strings.add(" ");
                strings.add(condition);
            }
        }
        return strings.toString();
    }

    @Override
    public String toString() {
        return "Join(joinMode=" + this.joinMode + ", query=" + this.query + ", name=" + this.name + ")";
    }

    protected Join query(Query query) {
        this.query = query;
        return this;
    }

    protected Join name(String name) {
        this.name = name;
        return this;
    }

    public static enum JoinMode implements QueryPart
    {
        INNER_JOIN("INNER JOIN"),
        OUTER_JOIN("OUTER JOIN"),
        LEFT_JOIN("LEFT JOIN"),
        RIGHT_JOIN("RIGHT JOIN"),
        CROSS_JOIN("CROSS JOIN");

        private final String string;

        private JoinMode(String string2) {
            this.string = string2;
        }

        @Override
        public String string(QueryOptions options) {
            return options.cased(this.string);
        }

        public String toString() {
            return "Join.JoinMode." + this.name() + "(string=" + this.string + ")";
        }
    }
}

