/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import com.github.eikecochu.sqlbuilder.BeforeOrderBy;
import com.github.eikecochu.sqlbuilder.BeforeUnion;
import com.github.eikecochu.sqlbuilder.Name;
import com.github.eikecochu.sqlbuilder.QueryBuilder;
import com.github.eikecochu.sqlbuilder.QueryOptions;
import com.github.eikecochu.sqlbuilder.QueryPart;
import com.github.eikecochu.sqlbuilder.QueryPartImpl;
import com.github.eikecochu.sqlbuilder.StringJoiner;
import java.util.ArrayList;
import java.util.List;

public class OrderBy
extends QueryPartImpl<OrderBy>
implements QueryBuilder,
BeforeUnion {
    private final List<OrderByTerm> orderByTerms = new ArrayList<OrderByTerm>();

    protected OrderBy(BeforeOrderBy parent) {
        super(parent);
    }

    public OrderBy column(String name, boolean ascending) {
        this.orderByTerms.add(new OrderByTerm(name, ascending));
        return this;
    }

    public OrderBy column(String name) {
        if (name != null) {
            String nameUpper = name.toUpperCase().trim();
            boolean ascending = true;
            if (nameUpper.endsWith(" DESC")) {
                ascending = false;
                name = name.replaceAll("\\s+[Dd][Ee][Ss][Cc]\\s*$", "");
            } else {
                name = name.replaceAll("\\s+[Aa][Ss][Cc]\\s*$", "");
            }
            String schema = null;
            if (name.contains(".")) {
                String[] parts = name.split("\\.");
                schema = parts[0];
                name = parts[1];
            }
            this.orderByTerms.add(new OrderByTerm(schema, name, ascending));
        }
        return this;
    }

    public OrderBy columns(String ... names) {
        if (names != null) {
            for (String name : names) {
                this.column(name);
            }
        }
        return this;
    }

    public OrderBy asc(String name) {
        return this.column(name, true);
    }

    public OrderBy desc(String name) {
        return this.column(name, false);
    }

    @Override
    public String string(QueryOptions options) {
        StringJoiner strings = new StringJoiner();
        if (this.parent() != null) {
            strings.add(this.parent().string(options));
        }
        if (strings.notEmpty()) {
            strings.add(options.newLine());
        }
        if (this.sql() != null) {
            strings.add(options.padded(this.sql()));
        } else {
            StringJoiner orderStrings = new StringJoiner();
            for (OrderByTerm orderByTerm : this.orderByTerms) {
                orderStrings.add(orderByTerm.string(options));
            }
            if (orderStrings.notEmpty()) {
                strings.add(options.padCased("ORDER BY"));
                strings.add(" ");
                strings.add(orderStrings.toString(", "));
            }
        }
        return strings.toString();
    }

    public String toString() {
        return "OrderBy(orderByTerms=" + this.orderByTerms + ")";
    }

    public OrderBy() {
    }

    private static class OrderByTerm
    implements QueryPart {
        private final Name name;
        private final boolean ascending;

        protected OrderByTerm(String name, boolean ascending) {
            this(null, name, ascending);
        }

        protected OrderByTerm(String schema, String name, boolean ascending) {
            this.name = new Name().schema(schema).name(name);
            this.ascending = ascending;
        }

        @Override
        public String string(QueryOptions options) {
            return this.name.string(options) + " " + options.cased(this.ascending ? "ASC" : "DESC");
        }

        public String toString() {
            return "OrderBy.OrderByTerm(name=" + this.name() + ", ascending=" + this.ascending() + ")";
        }

        protected Name name() {
            return this.name;
        }

        protected boolean ascending() {
            return this.ascending;
        }
    }
}

