/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import com.github.eikecochu.sqlbuilder.QueryBuilder;
import com.github.eikecochu.sqlbuilder.QueryOptions;
import com.github.eikecochu.sqlbuilder.QueryPart;
import com.github.eikecochu.sqlbuilder.QueryPartImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class Query
extends QueryPartImpl<Query>
implements QueryBuilder {
    private QueryOptions options;

    Query(QueryPart parent) {
        super(parent);
    }

    public String toString() {
        return this.string();
    }

    @Override
    public String string(QueryOptions options) {
        return this.string(options, null);
    }

    public String string(QueryOptions options, Connection connection) {
        String sql = this.sql();
        if (sql == null && this.parent() != null) {
            sql = this.parent().string(this.safeOptions(options));
        }
        if (options.sqlPostprocessor() != null) {
            sql = options.sqlPostprocessor().process(sql, connection);
        }
        return sql;
    }

    public PreparedStatement prepare(Connection connection) throws SQLException {
        return this.prepare(connection, this.options);
    }

    public PreparedStatement prepare(Connection connection, QueryOptions options) throws SQLException {
        options = this.safeOptions(options).prepare(true);
        String sql = this.string(options, connection);
        PreparedStatement stmt = options.returnGeneratedKeys() ? connection.prepareStatement(sql, 1) : connection.prepareStatement(sql);
        stmt = options.applyStatementOptions(stmt);
        if (options.stmtPostprocessor() != null) {
            stmt = options.stmtPostprocessor().process(stmt, connection);
        }
        int index = 1;
        for (Object value : options.preparedValues()) {
            if (value != null && options.valueConverters() != null && options.valueConverters().containsKey(value.getClass())) {
                value = options.valueConverters().get(value.getClass()).apply(value);
            }
            stmt.setObject(index++, value);
        }
        return stmt;
    }

    private QueryOptions safeOptions(QueryOptions options) {
        options = options == null ? QueryOptions.DEFAULT_OPTIONS : options;
        return options.copy().query(this);
    }

    @Override
    public Query query() {
        return this;
    }

    public QueryOptions options() {
        return this.options;
    }

    public Query options(QueryOptions options) {
        this.options = options;
        return this;
    }
}

