/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import com.github.eikecochu.sqlbuilder.Name;
import com.github.eikecochu.sqlbuilder.PostProcessor;
import com.github.eikecochu.sqlbuilder.Query;
import com.github.eikecochu.sqlbuilder.StringUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.NonNull;

public class QueryOptions {
    public static int FETCH_ALL = 0;
    @NonNull
    static QueryOptions DEFAULT_OPTIONS = new QueryOptions();
    private int padLength = "SELECT".length();
    private boolean splitNames = true;
    private boolean pretty = true;
    private boolean indent = true;
    private boolean uppercase = true;
    private boolean quote = false;
    private char quoteStartChar = (char)34;
    private char quoteEndChar = (char)34;
    private String dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private PostProcessor<String> sqlPostprocessor = null;
    private PostProcessor<PreparedStatement> stmtPostprocessor = null;
    private Map<Class<?>, Function<Object, Object>> valueConverters = null;
    private boolean returnGeneratedKeys = false;
    private int fetchSize = FETCH_ALL;
    private int fetchDirection = 1000;
    private boolean escapeKeywords = false;
    private String lineDelimiter = "\n";
    private boolean conditionOnNewline = false;
    private boolean ignoreNull = true;
    private String defaultPlaceholder = null;
    private int indentLevel = 0;
    private boolean prepare;
    private final List<Object> preparedValues = new ArrayList<Object>();
    private Query query;

    void addPreparedValue(Object value) {
        this.preparedValues.add(value);
    }

    public String indentString() {
        if (this.pretty && this.indent) {
            return StringUtils.repeat(' ', this.indentLevel * this.padLength + (this.indentLevel == 0 ? 0 : 1));
        }
        return "";
    }

    public String newLine() {
        return this.newLine(false);
    }

    public String newLine(boolean noSpace) {
        return this.pretty ? this.lineDelimiter + this.indentString() : (noSpace ? "" : " ");
    }

    public String padCased(String keyword) {
        return this.cased(this.padded(keyword));
    }

    public String ticked(String string) {
        if (string == null) {
            return null;
        }
        return this.quote || this.escapeKeywords && Name.isKeyword(string) ? this.quoteStartChar + string + this.quoteEndChar : string;
    }

    public String padded(String keyword) {
        if (this.pretty && keyword != null) {
            int length = Math.max(0, this.padLength - keyword.split("\\s+")[0].length());
            return StringUtils.leftPad("", length) + this.cased(keyword);
        }
        return keyword;
    }

    public String cased(String string) {
        if (string == null) {
            return null;
        }
        return this.uppercase ? string.toUpperCase() : string.toLowerCase();
    }

    public QueryOptions copy() {
        return new QueryOptions().padLength(this.padLength).splitNames(this.splitNames).pretty(this.pretty).indent(this.indent).uppercase(this.uppercase).quote(this.quote).quoteStartChar(this.quoteStartChar).quoteEndChar(this.quoteEndChar).dateFormat(this.dateFormat).sqlPostprocessor(this.sqlPostprocessor).stmtPostprocessor(this.stmtPostprocessor).valueConverters(this.valueConverters == null ? null : new HashMap(this.valueConverters)).returnGeneratedKeys(this.returnGeneratedKeys).fetchSize(this.fetchSize).fetchDirection(this.fetchDirection).escapeKeywords(this.escapeKeywords).lineDelimiter(this.lineDelimiter).conditionOnNewline(this.conditionOnNewline).ignoreNull(this.ignoreNull).defaultPlaceholder(this.defaultPlaceholder).indentLevel(this.indentLevel);
    }

    public String preparedValuesString() {
        StringBuilder sb = new StringBuilder();
        int index = 1;
        String prefix = "";
        for (Object value : this.preparedValues) {
            sb.append(prefix).append(index++).append(": ").append(value.toString());
            prefix = ", ";
        }
        return sb.toString();
    }

    PreparedStatement applyStatementOptions(PreparedStatement stmt) throws SQLException {
        stmt.setFetchSize(this.fetchSize);
        stmt.setMaxRows(this.fetchSize);
        stmt.setFetchDirection(this.fetchDirection);
        return stmt;
    }

    public QueryOptions fetchAll() {
        return this.fetchSize(FETCH_ALL);
    }

    public QueryOptions fetchFirst() {
        return this.fetchSize(1);
    }

    public <T> QueryOptions convert(Class<T> clazz, Function<T, Object> func) {
        if (this.valueConverters == null) {
            this.valueConverters = new HashMap();
        }
        this.valueConverters.put(clazz, func);
        return this;
    }

    public static QueryOptions getDefaultOptions() {
        return DEFAULT_OPTIONS.copy();
    }

    public static void setDefaultOptions(QueryOptions options) {
        if (options != null) {
            DEFAULT_OPTIONS = options.copy();
        }
    }

    public String toString() {
        return "QueryOptions(padLength=" + this.padLength() + ", splitNames=" + this.splitNames() + ", pretty=" + this.pretty() + ", indent=" + this.indent() + ", uppercase=" + this.uppercase() + ", quote=" + this.quote() + ", quoteStartChar=" + this.quoteStartChar() + ", quoteEndChar=" + this.quoteEndChar() + ", dateFormat=" + this.dateFormat() + ", sqlPostprocessor=" + this.sqlPostprocessor() + ", stmtPostprocessor=" + this.stmtPostprocessor() + ", valueConverters=" + this.valueConverters() + ", returnGeneratedKeys=" + this.returnGeneratedKeys() + ", fetchSize=" + this.fetchSize() + ", fetchDirection=" + this.fetchDirection() + ", escapeKeywords=" + this.escapeKeywords() + ", lineDelimiter=" + this.lineDelimiter() + ", conditionOnNewline=" + this.conditionOnNewline() + ", ignoreNull=" + this.ignoreNull() + ", defaultPlaceholder=" + this.defaultPlaceholder() + ", indentLevel=" + this.indentLevel() + ", prepare=" + this.prepare() + ", preparedValues=" + this.preparedValues() + ", query=" + this.query() + ")";
    }

    public int padLength() {
        return this.padLength;
    }

    public boolean splitNames() {
        return this.splitNames;
    }

    public boolean pretty() {
        return this.pretty;
    }

    public boolean indent() {
        return this.indent;
    }

    public boolean uppercase() {
        return this.uppercase;
    }

    public boolean quote() {
        return this.quote;
    }

    public char quoteStartChar() {
        return this.quoteStartChar;
    }

    public char quoteEndChar() {
        return this.quoteEndChar;
    }

    public String dateFormat() {
        return this.dateFormat;
    }

    public PostProcessor<String> sqlPostprocessor() {
        return this.sqlPostprocessor;
    }

    public PostProcessor<PreparedStatement> stmtPostprocessor() {
        return this.stmtPostprocessor;
    }

    public Map<Class<?>, Function<Object, Object>> valueConverters() {
        return this.valueConverters;
    }

    public boolean returnGeneratedKeys() {
        return this.returnGeneratedKeys;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public int fetchDirection() {
        return this.fetchDirection;
    }

    public boolean escapeKeywords() {
        return this.escapeKeywords;
    }

    public String lineDelimiter() {
        return this.lineDelimiter;
    }

    public boolean conditionOnNewline() {
        return this.conditionOnNewline;
    }

    public boolean ignoreNull() {
        return this.ignoreNull;
    }

    public String defaultPlaceholder() {
        return this.defaultPlaceholder;
    }

    public Query query() {
        return this.query;
    }

    public QueryOptions padLength(int padLength) {
        this.padLength = padLength;
        return this;
    }

    public QueryOptions splitNames(boolean splitNames) {
        this.splitNames = splitNames;
        return this;
    }

    public QueryOptions pretty(boolean pretty) {
        this.pretty = pretty;
        return this;
    }

    public QueryOptions indent(boolean indent) {
        this.indent = indent;
        return this;
    }

    public QueryOptions uppercase(boolean uppercase) {
        this.uppercase = uppercase;
        return this;
    }

    public QueryOptions quote(boolean quote) {
        this.quote = quote;
        return this;
    }

    public QueryOptions quoteStartChar(char quoteStartChar) {
        this.quoteStartChar = quoteStartChar;
        return this;
    }

    public QueryOptions quoteEndChar(char quoteEndChar) {
        this.quoteEndChar = quoteEndChar;
        return this;
    }

    public QueryOptions dateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public QueryOptions sqlPostprocessor(PostProcessor<String> sqlPostprocessor) {
        this.sqlPostprocessor = sqlPostprocessor;
        return this;
    }

    public QueryOptions stmtPostprocessor(PostProcessor<PreparedStatement> stmtPostprocessor) {
        this.stmtPostprocessor = stmtPostprocessor;
        return this;
    }

    public QueryOptions valueConverters(Map<Class<?>, Function<Object, Object>> valueConverters) {
        this.valueConverters = valueConverters;
        return this;
    }

    public QueryOptions returnGeneratedKeys(boolean returnGeneratedKeys) {
        this.returnGeneratedKeys = returnGeneratedKeys;
        return this;
    }

    public QueryOptions fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public QueryOptions fetchDirection(int fetchDirection) {
        this.fetchDirection = fetchDirection;
        return this;
    }

    public QueryOptions escapeKeywords(boolean escapeKeywords) {
        this.escapeKeywords = escapeKeywords;
        return this;
    }

    public QueryOptions lineDelimiter(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
        return this;
    }

    public QueryOptions conditionOnNewline(boolean conditionOnNewline) {
        this.conditionOnNewline = conditionOnNewline;
        return this;
    }

    public QueryOptions ignoreNull(boolean ignoreNull) {
        this.ignoreNull = ignoreNull;
        return this;
    }

    public QueryOptions defaultPlaceholder(String defaultPlaceholder) {
        this.defaultPlaceholder = defaultPlaceholder;
        return this;
    }

    public QueryOptions query(Query query) {
        this.query = query;
        return this;
    }

    int indentLevel() {
        return this.indentLevel;
    }

    QueryOptions indentLevel(int indentLevel) {
        this.indentLevel = indentLevel;
        return this;
    }

    boolean prepare() {
        return this.prepare;
    }

    QueryOptions prepare(boolean prepare) {
        this.prepare = prepare;
        return this;
    }

    List<Object> preparedValues() {
        return this.preparedValues;
    }
}

