/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import com.github.eikecochu.sqlbuilder.BeforeFrom;
import com.github.eikecochu.sqlbuilder.BeforeSelect;
import com.github.eikecochu.sqlbuilder.QueryOptions;
import com.github.eikecochu.sqlbuilder.QueryPartImpl;
import com.github.eikecochu.sqlbuilder.QueryUtils;
import com.github.eikecochu.sqlbuilder.StringJoiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Select
extends QueryPartImpl<Select>
implements BeforeFrom {
    private final List<String> columns = new ArrayList<String>();
    private boolean distinct = false;
    private boolean all = false;

    public Select(String ... columns) {
        this.columns(columns);
    }

    protected Select(BeforeSelect parent) {
        super(parent);
    }

    public Select distinct() {
        this.distinct = true;
        this.all = false;
        return this;
    }

    public Select all() {
        this.distinct = false;
        this.all = true;
        return this;
    }

    public Select column(String column) {
        this.columns.add(column);
        return this;
    }

    public Select columns(String ... columns) {
        if (columns != null) {
            this.columns.addAll(Arrays.asList(columns));
        }
        return this;
    }

    @Override
    public String string(QueryOptions options) {
        StringJoiner strings = new StringJoiner();
        if (this.parent() != null) {
            strings.add(this.parent().string(options));
        }
        if (strings.notEmpty()) {
            strings.add(options.newLine());
        }
        if (this.sql() != null) {
            strings.add(options.padded(this.sql()));
        } else {
            strings.add(options.padCased("SELECT"));
            if (this.distinct) {
                strings.add(" ");
                strings.add(options.cased("DISTINCT"));
            } else if (this.all) {
                strings.add(" ");
                strings.add(options.cased("ALL"));
            }
            if (this.columns.isEmpty()) {
                strings.add(" *");
            } else {
                StringJoiner columnsStrings = new StringJoiner();
                for (String column : this.columns) {
                    columnsStrings.add(QueryUtils.splitName(options, column).string(options));
                }
                strings.add(" ");
                strings.add(columnsStrings.toString(", "));
            }
        }
        return strings.toString();
    }

    public String toString() {
        return "Select(columns=" + this.columns + ", distinct=" + this.distinct() + ", all=" + this.all() + ")";
    }

    public Select() {
    }

    protected Select distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    protected Select all(boolean all) {
        this.all = all;
        return this;
    }
}

