/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

abstract class StringUtils {
    private StringUtils() {
    }

    public static String join(Iterable<String> it, String delim) {
        if (delim == null) {
            delim = "";
        }
        String d = "";
        StringBuilder sb = new StringBuilder();
        for (String s : it) {
            sb.append(d).append(s);
            d = delim;
        }
        return sb.toString();
    }

    public static String leftPad(String s, int length) {
        if (s == null || s.length() >= length) {
            return s;
        }
        StringBuilder sBuilder = new StringBuilder(s);
        while (sBuilder.length() < length) {
            sBuilder.insert(0, " ");
        }
        s = sBuilder.toString();
        return s;
    }

    public static String repeat(String s, int times) {
        if (times <= 0) {
            return "";
        }
        if (s == null || s.isEmpty() || times == 1) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String repeat(char c, int times) {
        return StringUtils.repeat("" + c, times);
    }
}

