/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import com.github.eikecochu.sqlbuilder.BeforeDelete;
import com.github.eikecochu.sqlbuilder.BeforeInsert;
import com.github.eikecochu.sqlbuilder.BeforeSelect;
import com.github.eikecochu.sqlbuilder.BeforeUpdate;
import com.github.eikecochu.sqlbuilder.BeforeWith;
import com.github.eikecochu.sqlbuilder.QueryBuilder;
import com.github.eikecochu.sqlbuilder.QueryOptions;
import com.github.eikecochu.sqlbuilder.QueryPartImpl;
import com.github.eikecochu.sqlbuilder.StringJoiner;
import com.github.eikecochu.sqlbuilder.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class With
extends QueryPartImpl<With>
implements BeforeWith,
BeforeSelect,
BeforeUpdate,
BeforeDelete,
BeforeInsert {
    private final String name;
    private final List<String> columns = new ArrayList<String>();
    private QueryBuilder query;
    private boolean recursive;

    public With(String name) {
        this(null, name);
    }

    protected With(BeforeWith parent, String name) {
        super(parent);
        this.name = name;
    }

    public With recursive() {
        this.recursive = true;
        return this;
    }

    public With column(String column) {
        this.columns.add(column);
        return this;
    }

    public With columns(String ... columns) {
        this.columns.addAll(Arrays.asList(columns));
        return this;
    }

    public With as(QueryBuilder builder) {
        this.query = builder;
        return this;
    }

    @Override
    public String string(QueryOptions options) {
        StringJoiner strings = new StringJoiner();
        if (this.parent() != null) {
            strings.add(this.parent().string(options));
        }
        if (strings.notEmpty()) {
            strings.add(",");
            strings.add(options.newLine(true));
            strings.add(options.padded(""));
            strings.add(" ");
        }
        if (this.sql() != null) {
            strings.add(this.sql());
        } else {
            if (this.parent() == null) {
                strings.add(options.padCased("WITH "));
                if (this.recursive) {
                    strings.add(options.cased("RECURSIVE "));
                }
            }
            strings.add(this.name);
            if (!this.columns.isEmpty()) {
                strings.add(" (");
                strings.add(StringUtils.join(this.columns, ", "));
                strings.add(")");
            }
            strings.add(" ");
            strings.add(options.cased("AS"));
            strings.add(" (");
            QueryOptions subOptions = options.copy().indentLevel(options.indentLevel() + 1);
            strings.add(subOptions.newLine(true));
            strings.add(this.query.string(subOptions).trim());
            strings.add(")");
        }
        return strings.toString();
    }

    public String toString() {
        return "With(name=" + this.name + ", columns=" + this.columns + ", query=" + this.query + ", recursive=" + this.recursive() + ")";
    }

    protected With query(QueryBuilder query) {
        this.query = query;
        return this;
    }

    protected With recursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }
}

