/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import com.github.eikecochu.sqlbuilder.CompareOperator;
import com.github.eikecochu.sqlbuilder.Condition;
import com.github.eikecochu.sqlbuilder.ConditionPart;
import com.github.eikecochu.sqlbuilder.ConditionValueType;
import com.github.eikecochu.sqlbuilder.ConjunctiveOperator;
import com.github.eikecochu.sqlbuilder.NestedCondition;
import com.github.eikecochu.sqlbuilder.QueryOptions;
import com.github.eikecochu.sqlbuilder.QueryPart;
import com.github.eikecochu.sqlbuilder.QueryPartImpl;
import com.github.eikecochu.sqlbuilder.QueryPartLinked;
import com.github.eikecochu.sqlbuilder.StringJoiner;
import com.github.eikecochu.sqlbuilder.ValueHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public abstract class Conditionable<T extends Conditionable<T>>
extends QueryPartImpl<T> {
    private final List<QueryPart> parts = new ArrayList<QueryPart>();

    public Conditionable() {
        this(null);
    }

    protected Conditionable(QueryPartLinked<?> parent) {
        super(parent);
    }

    public T values(ValueHolder values) {
        return this.values(values, null);
    }

    public T values(ValueHolder values, String columnPrefix) {
        if (values != null) {
            Iterator<Map.Entry<String, Object>> it = values.values(columnPrefix);
            while (it.hasNext()) {
                Map.Entry<String, Object> value = it.next();
                this.col(value.getKey(), value.getValue());
            }
        }
        return this.self();
    }

    public T col(String name, CompareOperator operator, ConditionValueType type, Object ... values) {
        return this.col(name).condition(operator, type, values);
    }

    public T col(String name, String operator, ConditionValueType type, Object ... values) {
        return this.col(name, CompareOperator.fromString(operator), type, values);
    }

    public ConditionPart<T> col(String name) {
        ConditionPart part = new ConditionPart(this, name);
        this.addPart(part);
        return part;
    }

    public T col(String name, Object value) {
        return this.col(name).eq(value);
    }

    public T colsEq(String name1, String name2) {
        return this.col(name1).eqCol(name2);
    }

    public T col(String name, Object ... values) {
        return this.col(name).in(values);
    }

    public T group(Condition group) {
        return this.addPart(group);
    }

    public NestedCondition<T> groupStart() {
        NestedCondition group = new NestedCondition(this);
        this.addPart(group);
        return group;
    }

    public T and() {
        return this.op(ConjunctiveOperator.AND);
    }

    public T or() {
        return this.op(ConjunctiveOperator.OR);
    }

    T addPart(QueryPart part) {
        if (!this.parts.isEmpty() && !(this.parts.get(this.parts.size() - 1) instanceof ConjunctiveOperator)) {
            this.and();
        }
        this.parts.add(part);
        return this.self();
    }

    private T op(ConjunctiveOperator operator) {
        if (!this.parts.isEmpty() && this.parts.size() % 2 == 1) {
            this.parts.add(operator);
        }
        return this.self();
    }

    private T self() {
        return (T)this;
    }

    @Override
    public String string(QueryOptions options) {
        StringJoiner strings = new StringJoiner();
        ArrayList<QueryPart> validParts = new ArrayList<QueryPart>(this.parts.size());
        boolean valueNext = true;
        for (QueryPart part : this.parts) {
            if (valueNext == !(part instanceof ConjunctiveOperator)) {
                validParts.add(part);
            }
            valueNext = !valueNext;
        }
        ListIterator it = validParts.listIterator(validParts.size());
        while (it.hasPrevious() && it.previous() instanceof ConjunctiveOperator) {
            it.remove();
        }
        if (validParts.isEmpty()) {
            return null;
        }
        String first = ((QueryPart)validParts.get(0)).string(options);
        boolean needsOp = false;
        if (first != null && !first.isEmpty()) {
            needsOp = true;
            strings.add(first);
        }
        for (int i = 1; i < validParts.size(); i += 2) {
            String op = ((QueryPart)validParts.get(i)).string(options);
            String val = ((QueryPart)validParts.get(i + 1)).string(options);
            if (needsOp) {
                if (op == null || op.isEmpty() || val == null || val.isEmpty()) continue;
                if (options.conditionOnNewline()) {
                    strings.add(options.newLine());
                    strings.add(options.padded(op));
                    strings.add(" ");
                } else {
                    strings.add(op);
                }
                strings.add(val);
                continue;
            }
            if (val == null || val.isEmpty()) continue;
            needsOp = true;
            strings.add(val);
        }
        return strings.toString(options.conditionOnNewline() ? "" : " ");
    }

    public String toString() {
        return "Conditionable(parts=" + this.getParts() + ")";
    }

    protected List<QueryPart> getParts() {
        return this.parts;
    }
}

