/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import com.github.eikecochu.sqlbuilder.Query;
import com.github.eikecochu.sqlbuilder.QueryBuilder;
import com.github.eikecochu.sqlbuilder.QueryOptions;
import com.github.eikecochu.sqlbuilder.QueryPartImpl;
import java.util.ArrayList;
import java.util.List;

public class Expression
extends QueryPartImpl<Expression>
implements QueryBuilder<Expression> {
    private String expression;
    private List<Object> values = new ArrayList<Object>();
    private List<Integer> paramTypes = new ArrayList<Integer>();
    private int returnType = 0;
    private boolean standalone = false;

    public Expression(String expression, Object ... values) {
        this.expression = expression;
        if (values != null) {
            for (Object value : values) {
                this.in(value);
            }
        }
    }

    public Expression in(Object value) {
        return this.inOut(value, 0);
    }

    public Expression out(int type) {
        return this.inOut(null, type);
    }

    public Expression inOut(Object value, int type) {
        this.values.add(value);
        this.paramTypes.add(type);
        return this;
    }

    public Expression setIn(int index, Object value) {
        return this.setInOut(index, value, 0);
    }

    public Expression setIns(Object ... values) {
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                this.setIn(i, values[i]);
            }
        }
        return this;
    }

    public Expression setOut(int index, int type) {
        return this.setInOut(index, null, type);
    }

    public Expression setOuts(Integer ... types) {
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                this.setOut(i, types[i]);
            }
        }
        return this;
    }

    public Expression setInOut(int index, Object value, int type) {
        if (index < 0) {
            throw new RuntimeException("bad index");
        }
        while (index + 1 > this.paramTypes.size()) {
            this.in(null);
        }
        if (value != null) {
            this.values.set(index, value);
        }
        this.paramTypes.set(index, type);
        return this;
    }

    public String toString() {
        return this.string();
    }

    @Override
    public String string(QueryOptions options) {
        return this.string(options, options.prepare());
    }

    public String string(QueryOptions options, boolean prepare) {
        if (this.values != null && this.paramTypes != null && this.values.size() != this.paramTypes.size()) {
            throw new RuntimeException("values and paramTypes size does not match");
        }
        options = this.safeOptions(options);
        String result = this.expression;
        if (this.values != null && this.values.size() > 0 && !result.contains("(")) {
            String defaultPlaceholder;
            if (!prepare) {
                for (int i = 0; i < this.values.size(); ++i) {
                    if (this.values.get(i) != null || this.paramTypes.get(i) == 0) continue;
                    throw new RuntimeException("non-prepare method does not support OUT parameters");
                }
            }
            boolean hasPlaceholder = (defaultPlaceholder = options.defaultPlaceholder()) != null && !defaultPlaceholder.isEmpty();
            StringBuilder params = new StringBuilder();
            String delim = "";
            boolean defaults = false;
            for (Object value : this.values) {
                if (value == null) {
                    defaults = true;
                    if (hasPlaceholder) {
                        params.append(delim).append(defaultPlaceholder);
                    }
                } else {
                    if (defaults && !hasPlaceholder) {
                        throw new RuntimeException("middle parameter null");
                    }
                    params.append(delim).append(prepare ? "?" : value);
                    if (prepare) {
                        options.addPreparedValue(value);
                    }
                }
                delim = ", ";
            }
            String paramString = params.toString();
            if (!paramString.isEmpty()) {
                result = result + "(" + paramString + ")";
            }
        }
        if (this.standalone) {
            result = "call " + result;
            if (this.returnType != 0) {
                result = "? = " + result;
            }
            result = "{ " + result + " }";
        }
        return result;
    }

    public String preparedString(QueryOptions options) {
        return this.string(options, true);
    }

    public String valueString(QueryOptions options) {
        return this.string(options, false);
    }

    private QueryOptions safeOptions(QueryOptions options) {
        return options == null ? QueryOptions.getDefaultOptions() : options;
    }

    @Override
    public Query query() {
        this.standalone = true;
        return new Query(this);
    }

    public String expression() {
        return this.expression;
    }

    public List<Object> values() {
        return this.values;
    }

    public List<Integer> paramTypes() {
        return this.paramTypes;
    }

    public int returnType() {
        return this.returnType;
    }

    public Expression expression(String expression) {
        this.expression = expression;
        return this;
    }

    public Expression values(List<Object> values) {
        this.values = values;
        return this;
    }

    public Expression paramTypes(List<Integer> paramTypes) {
        this.paramTypes = paramTypes;
        return this;
    }

    public Expression returnType(int returnType) {
        this.returnType = returnType;
        return this;
    }

    public Expression() {
    }

    public Expression(String expression, List<Object> values, List<Integer> paramTypes, int returnType, boolean standalone) {
        this.expression = expression;
        this.values = values;
        this.paramTypes = paramTypes;
        this.returnType = returnType;
        this.standalone = standalone;
    }
}

