/*
 * Decompiled with CFR 0.152.
 */
package com.github.eikecochu.sqlbuilder;

import com.github.eikecochu.sqlbuilder.Name;
import com.github.eikecochu.sqlbuilder.QueryOptions;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class QueryUtils {
    private static final Pattern namePattern = Pattern.compile("^\\s*((?<fn>\\w+)\\()?([\"'`]?(?<a1>\\w+)[\"'`]?\\.)?([\"'`]?(?<a2>\\w+)[\"'`]?\\.)?([\"'`]?(?<name>\\w+|\\*)[\"'`]?)\\)?(\\s+[Aa][Ss])?(\\s+[\"'`]?(?<alias>\\w+))?[\"'`]?\\s*$");

    QueryUtils() {
    }

    public static Name splitName(QueryOptions options, String strName) {
        if (!options.splitNames()) {
            return new Name().name(strName);
        }
        Matcher m = namePattern.matcher(strName);
        if (m.matches()) {
            String schema = m.group("a1");
            String table = m.group("a2");
            if (table == null) {
                table = schema;
                schema = null;
            }
            return new Name().function(m.group("fn")).schema(schema).table(table).name(m.group("name")).alias(m.group("alias"));
        }
        if (options.ignoreUnrecognizableNames()) {
            return new Name().name(strName).unrecognized(true);
        }
        throw new RuntimeException("unrecognizable name: " + strName);
    }

    public static String valueToString(QueryOptions options, Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return "'" + QueryUtils.sqlStringEscape(value.toString()) + "'";
        }
        if (value instanceof Integer) {
            return Integer.toString((Integer)value);
        }
        if (value instanceof Long) {
            return Long.toString((Long)value);
        }
        if (value instanceof Double) {
            return Double.toString((Double)value);
        }
        if (value instanceof Float) {
            return Float.toString(((Float)value).floatValue());
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "true" : "false";
        }
        if (value instanceof Date) {
            return new SimpleDateFormat(options == null ? "yyyy-MM-dd'T'HH:mm:ss.SSSZ" : options.dateFormat()).format((Date)value);
        }
        return "";
    }

    public static List<String> valuesToStrings(QueryOptions options, Object ... values) {
        return Arrays.stream(values).map(value -> QueryUtils.valueToString(options, value)).collect(Collectors.toList());
    }

    public static String sqlStringEscape(String string) {
        return string.replaceAll("'(?!')", "''");
    }

    public static String preparedInValues(int count) {
        if (count <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("?");
        --count;
        while (count > 0) {
            sb.append(", ?");
            --count;
        }
        return sb.toString();
    }
}

