/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.ufrn.imd.obd.commands;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

/**
 * Interface with OBD Command behaviours
 */
public interface IObdCommand {
    void run(InputStream in, OutputStream out) throws IOException, InterruptedException;

    Object getResult();

    Object getFormattedResult();

    Object getResultUnit();

    Object getName();

    Object getCommandPID();

    Map<String, String> getMap();

    long getElapsedTime();

    String toString();
}
