/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.ufrn.imd.obd.commands.protocol;

import br.ufrn.imd.obd.commands.ObdCommand;
import br.ufrn.imd.obd.enums.AvailableCommand;

/**
 * <p>Abstract ObdProtocolCommand class.</p>
 */
public abstract class ObdProtocolCommand extends ObdCommand {

    /**
     * Default constructor to use
     *
     * @param command the command to send
     */
    public ObdProtocolCommand(AvailableCommand command) {
        super(command);
    }

    /**
     * Copy constructor.
     *
     * @param other the ObdCommand to copy.
     */
    public ObdProtocolCommand(ObdProtocolCommand other) {
        this(other.cmd);
    }

    /**
     * <p>performCalculations.</p>
     */
    protected void performCalculations() {
        // Empty method
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void fillBuffer() {
        // settings commands don't return a value appropriate to place into the buffer, so do nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getCalculatedResult() {
        return getResult();
    }

}
