/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.database.mybatis.plugin.search.filter;

import com.github.fartherp.framework.database.mybatis.plugin.search.enums.RelationEnum;
import com.github.fartherp.framework.database.mybatis.plugin.search.enums.SearchOperator;
import com.github.fartherp.framework.database.mybatis.plugin.search.exception.InvlidSearchOperatorException;
import com.github.fartherp.framework.database.mybatis.plugin.search.exception.SearchException;
import com.github.fartherp.framework.database.mybatis.plugin.search.filter.SearchFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomCondition
implements SearchFilter {
    public static final String separator = "_";
    private String key;
    private String searchProperty;
    private SearchOperator operator;
    private Object value;
    private List<CustomCondition> andFilters = new ArrayList<CustomCondition>();
    private List<CustomCondition> orFilters = new ArrayList<CustomCondition>();

    public void addCustomCondition(RelationEnum value, List<CustomCondition> others) {
        if (value.getValue().equalsIgnoreCase("and")) {
            this.andFilters.addAll(others);
        }
        if (value.getValue().equalsIgnoreCase("or")) {
            this.orFilters.addAll(others);
        }
    }

    public List<CustomCondition> getAndFilters() {
        return this.andFilters;
    }

    public List<CustomCondition> getOrFilters() {
        return this.orFilters;
    }

    public boolean hasAndFilters() {
        return !this.andFilters.isEmpty();
    }

    public boolean hasOrFilters() {
        return !this.orFilters.isEmpty();
    }

    static CustomCondition newCondition(String key, Object value) throws SearchException {
        SearchOperator operator;
        Assert.notNull((Object)key, (String)"CustomCondition key must not null");
        String[] searchs = StringUtils.split((String)key, (String)separator);
        if (searchs.length == 0) {
            throw new SearchException("CustomCondition key format must be : property or property_op");
        }
        String searchProperty = searchs[0];
        if (searchs.length == 1) {
            operator = SearchOperator.custom;
        } else if (searchs.length == 3) {
            searchProperty = searchs[0] + separator + searchs[1];
            operator = SearchOperator.valueOf(searchs[2]);
        } else {
            try {
                operator = SearchOperator.valueOf(searchs[1]);
            }
            catch (IllegalArgumentException e) {
                throw new InvlidSearchOperatorException(searchProperty, searchs[1]);
            }
        }
        boolean allowBlankValue = SearchOperator.isAllowBlankValue(operator);
        boolean isValueBlank = value == null;
        isValueBlank = isValueBlank || value instanceof String && StringUtils.isBlank((String)((String)value));
        boolean bl = isValueBlank = isValueBlank || value instanceof List && ((List)value).size() == 0;
        if (!allowBlankValue && isValueBlank) {
            return null;
        }
        return CustomCondition.newCondition(searchProperty, operator, value);
    }

    static CustomCondition newCondition(String searchProperty, SearchOperator operator, Object value) {
        return new CustomCondition(searchProperty, operator, value);
    }

    private CustomCondition(String searchProperty, SearchOperator operator, Object value) {
        this.searchProperty = searchProperty;
        this.operator = operator;
        this.value = value;
        this.key = this.searchProperty + separator + (Object)((Object)this.operator);
    }

    public String getKey() {
        return this.key;
    }

    public String getSearchProperty() {
        return this.searchProperty;
    }

    public SearchOperator getOperator() throws InvlidSearchOperatorException {
        return this.operator;
    }

    public String getOperatorStr() {
        if (this.operator != null) {
            return this.operator.getSymbol();
        }
        return "";
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setOperator(SearchOperator operator) {
        this.operator = operator;
    }

    public void setSearchProperty(String searchProperty) {
        this.searchProperty = searchProperty;
    }

    public String getEntityProperty() {
        return this.searchProperty;
    }

    public boolean isUnaryFilter() {
        String operatorStr = this.getOperator().getSymbol();
        return StringUtils.isNotEmpty((String)operatorStr) && operatorStr.startsWith("is");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomCondition that = (CustomCondition)o;
        return !(this.key == null ? that.key != null : !this.key.equals(that.key));
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    public String toString() {
        return "CustomCondition{searchProperty='" + this.searchProperty + '\'' + ", operator=" + (Object)((Object)this.operator) + ", value=" + this.value + '}';
    }
}

