/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.database.mybatis.plugin.search.vo;

import com.github.fartherp.framework.database.mybatis.plugin.page.PageRequest;
import com.github.fartherp.framework.database.mybatis.plugin.page.Pagination;
import com.github.fartherp.framework.database.mybatis.plugin.search.enums.SearchOperator;
import com.github.fartherp.framework.database.mybatis.plugin.search.exception.SearchException;
import com.github.fartherp.framework.database.mybatis.plugin.search.filter.CustomCondition;
import com.github.fartherp.framework.database.mybatis.plugin.search.filter.CustomConditionFactory;
import com.github.fartherp.framework.database.mybatis.plugin.search.filter.SearchFilter;
import com.github.fartherp.framework.database.mybatis.plugin.search.utils.SearchableConvertUtils;
import com.github.fartherp.framework.database.mybatis.plugin.search.vo.Searchable;
import com.github.fartherp.framework.database.mybatis.plugin.search.vo.Sort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchRequest
extends Searchable {
    private Map<String, SearchFilter> searchFilterMap = new HashMap<String, SearchFilter>();
    private List<SearchFilter> searchFilters = new ArrayList<SearchFilter>();

    public SearchRequest(Map<String, Object> searchParams) {
        this(searchParams, null, null);
    }

    public SearchRequest() {
    }

    public SearchRequest(Map<String, Object> searchParams, PageRequest page) {
        this(searchParams, page, null);
    }

    public SearchRequest(Map<String, Object> searchParams, Sort sort) throws SearchException {
        this(searchParams, null, sort);
    }

    public SearchRequest(Map<String, Object> searchParams, PageRequest page, Sort sort) throws SearchException {
        this.toSearchFilters(searchParams);
        this.merge(sort, page);
    }

    private void toSearchFilters(Map<String, Object> searchParams) throws SearchException {
        if (searchParams == null || searchParams.size() == 0) {
            return;
        }
        for (Map.Entry<String, Object> entry : searchParams.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.addSearchFilter(CustomConditionFactory.newCustomCondition(key, value));
        }
    }

    @Override
    public void removePageable() {
        this.page = null;
    }

    @Override
    public Searchable addSearchParam(String key, Object value) throws SearchException {
        this.addSearchFilter(CustomConditionFactory.newCustomCondition(key, value));
        return this;
    }

    @Override
    public Searchable addSearchParams(Map<String, Object> searchParams) throws SearchException {
        this.toSearchFilters(searchParams);
        return this;
    }

    @Override
    public Searchable addSearchFilter(String searchProperty, SearchOperator operator, Object value) {
        SearchFilter searchFilter = CustomConditionFactory.newCustomCondition(searchProperty, operator, value);
        return this.addSearchFilter(searchFilter);
    }

    @Override
    public Searchable addSearchFilter(SearchFilter searchFilter) {
        int index;
        if (searchFilter == null) {
            return this;
        }
        if (searchFilter instanceof CustomCondition) {
            CustomCondition customCondition = (CustomCondition)searchFilter;
            String key = customCondition.getKey();
            this.searchFilterMap.put(key, customCondition);
        }
        if ((index = this.searchFilters.indexOf(searchFilter)) != -1) {
            this.searchFilters.set(index, searchFilter);
        } else {
            this.searchFilters.add(searchFilter);
        }
        return this;
    }

    @Override
    public Searchable addSearchFilters(Collection<? extends SearchFilter> searchFilters) {
        if (CollectionUtils.isEmpty(searchFilters)) {
            return this;
        }
        for (SearchFilter searchFilter : searchFilters) {
            this.addSearchFilter(searchFilter);
        }
        return this;
    }

    @Override
    public Searchable or(SearchFilter first, SearchFilter ... others) {
        this.addSearchFilter(CustomConditionFactory.or(first, others));
        return this;
    }

    @Override
    public Searchable and(SearchFilter first, SearchFilter ... others) {
        this.addSearchFilter(CustomConditionFactory.and(first, others));
        return this;
    }

    @Override
    public Searchable removeSearchFilter(String searchProperty, SearchOperator operator) {
        this.removeSearchFilter(searchProperty + "_" + (Object)((Object)operator));
        return this;
    }

    @Override
    public Searchable removeSearchFilter(String key) {
        if (key == null) {
            return this;
        }
        SearchFilter searchFilter = this.searchFilterMap.remove(key);
        if (searchFilter == null) {
            searchFilter = this.searchFilterMap.remove(this.getCustomKey(key));
        }
        if (searchFilter == null) {
            return this;
        }
        this.searchFilters.remove(searchFilter);
        return this;
    }

    private String getCustomKey(String key) {
        return key + "_" + (Object)((Object)SearchOperator.custom);
    }

    public Searchable setPage(PageRequest page) {
        this.merge(this.sort, page);
        return this;
    }

    @Override
    public Searchable setPage(int pageNumber, int pageSize) {
        this.merge(this.sort, new PageRequest(pageNumber, pageSize));
        return this;
    }

    @Override
    public Searchable addSort(Sort sort) {
        this.merge(sort, this.page);
        return this;
    }

    @Override
    public Searchable addSort(Sort.Direction direction, String property) {
        this.merge(new Sort(direction, property), this.page);
        return this;
    }

    @Override
    public <T> Searchable convert(Class<T> entityClass) {
        SearchableConvertUtils.convertSearchValueToEntityValue(this, entityClass);
        this.markConverted();
        return this;
    }

    @Override
    public Searchable markConverted() {
        this.converted = true;
        return this;
    }

    @Override
    public Searchable setPage(Pagination page) {
        this.page = (PageRequest)page;
        return this;
    }

    @Override
    public Collection<SearchFilter> getSearchFilters() {
        return Collections.unmodifiableCollection(this.searchFilters);
    }

    @Override
    public boolean isConverted() {
        return this.converted;
    }

    @Override
    public boolean hasSearchFilter() {
        return this.searchFilters.size() > 0;
    }

    @Override
    public boolean hashSort() {
        return this.sort != null && this.sort.iterator().hasNext();
    }

    @Override
    public void removeSort() {
        this.sort = null;
        if (this.page != null) {
            this.page = new PageRequest(this.page.getCurrentPage(), this.page.getLimit());
        }
    }

    @Override
    public boolean hasPagination() {
        return false;
    }

    @Override
    public void removePagination() {
        this.page = null;
    }

    @Override
    public Pagination getPage() {
        return this.page;
    }

    @Override
    public boolean containsSearchKey(String key) {
        boolean contains;
        boolean bl = contains = this.searchFilterMap.containsKey(key) || this.searchFilterMap.containsKey(this.getCustomKey(key));
        if (contains) {
            return true;
        }
        return this.containsSearchKey(this.searchFilters, key);
    }

    @Override
    public boolean hasPageable() {
        return this.page != null && this.page.getLimit() > 0;
    }

    private boolean containsSearchKey(List<SearchFilter> searchFilters, String key) throws ClassCastException {
        boolean contains = false;
        for (SearchFilter searchFilter : searchFilters) {
            if (searchFilter instanceof CustomCondition) {
                CustomCondition customCondition = (CustomCondition)searchFilter;
                boolean bl = contains = customCondition.getKey().equals(key) || customCondition.getSearchProperty().equals(key);
            }
            if (((CustomCondition)searchFilter).hasOrFilters()) {
                List<CustomCondition> orConditions = ((CustomCondition)searchFilter).getOrFilters();
                contains = this.containsCustomKey(orConditions, key);
            }
            if (((CustomCondition)searchFilter).hasAndFilters()) {
                List<CustomCondition> andConditions = ((CustomCondition)searchFilter).getAndFilters();
                contains = this.containsCustomKey(andConditions, key);
            }
            if (!contains) continue;
            break;
        }
        return contains;
    }

    private boolean containsCustomKey(List<CustomCondition> conditions, String key) {
        for (CustomCondition customCondition : conditions) {
            if (!customCondition.getKey().equals(key) && !customCondition.getSearchProperty().equals(key)) continue;
            return true;
        }
        return false;
    }

    public Object getValue(String key) {
        SearchFilter searchFilter = this.searchFilterMap.get(key);
        if (searchFilter == null) {
            searchFilter = this.searchFilterMap.get(this.getCustomKey(key));
        }
        if (searchFilter == null) {
            return null;
        }
        if (searchFilter instanceof CustomCondition) {
            CustomCondition customCondition = (CustomCondition)searchFilter;
            return customCondition.getValue();
        }
        return null;
    }

    private void merge(Sort sort, PageRequest page) {
        if (sort == null) {
            sort = this.sort;
        }
        if (page == null) {
            page = this.page;
        }
        this.sort = sort == null ? (page != null ? sort : null) : (page != null ? sort.and(this.sort) : sort);
        this.page = page != null ? new PageRequest(page.getCurrentPage(), page.getLimit()) : null;
    }

    @Override
    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public String toString() {
        return "SearchRequest{searchFilterMap=" + this.searchFilterMap + ",page=" + this.page + ",sort=" + this.sort + '}';
    }
}

