/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.database.mybatis.plugin.search.vo;

import com.github.fartherp.framework.database.mybatis.plugin.page.PageRequest;
import com.github.fartherp.framework.database.mybatis.plugin.page.Pagination;
import com.github.fartherp.framework.database.mybatis.plugin.search.enums.SearchOperator;
import com.github.fartherp.framework.database.mybatis.plugin.search.exception.SearchException;
import com.github.fartherp.framework.database.mybatis.plugin.search.filter.SearchFilter;
import com.github.fartherp.framework.database.mybatis.plugin.search.vo.SearchRequest;
import com.github.fartherp.framework.database.mybatis.plugin.search.vo.Sort;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Searchable {
    public PageRequest page;
    public boolean converted;
    public Sort sort;

    public static Searchable newSearchable() {
        return new SearchRequest();
    }

    public void setConverted(boolean converted) {
        this.converted = converted;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public static Searchable newSearchable(Map<String, Object> searchParams) throws SearchException {
        return new SearchRequest(searchParams);
    }

    public static Searchable newSearchable(Map<String, Object> searchParams, PageRequest page) throws SearchException {
        return new SearchRequest(searchParams, page);
    }

    public static Searchable newSearchable(Map<String, Object> searchParams, Sort sort) throws SearchException {
        return new SearchRequest(searchParams, sort);
    }

    public static Searchable newSearchable(Map<String, Object> searchParams, PageRequest page, Sort sort) {
        return new SearchRequest(searchParams, page, sort);
    }

    public abstract void removePageable();

    public abstract Searchable addSearchParam(String var1, Object var2) throws SearchException;

    public abstract Searchable addSearchParams(Map<String, Object> var1) throws SearchException;

    public abstract Searchable addSearchFilter(String var1, SearchOperator var2, Object var3) throws SearchException;

    public abstract Searchable addSearchFilter(SearchFilter var1);

    public abstract Searchable addSearchFilters(Collection<? extends SearchFilter> var1);

    public abstract Searchable or(SearchFilter var1, SearchFilter ... var2);

    public abstract Searchable and(SearchFilter var1, SearchFilter ... var2);

    public abstract Searchable removeSearchFilter(String var1);

    public abstract Searchable removeSearchFilter(String var1, SearchOperator var2);

    public abstract <T> Searchable convert(Class<T> var1);

    public abstract Searchable markConverted();

    public abstract Searchable setPage(Pagination var1);

    public abstract Searchable setPage(int var1, int var2);

    public abstract Searchable addSort(Sort var1);

    public abstract Searchable addSort(Sort.Direction var1, String var2);

    public abstract Collection<SearchFilter> getSearchFilters();

    public abstract boolean isConverted();

    public abstract boolean hasSearchFilter();

    public abstract boolean hashSort();

    public abstract void removeSort();

    public abstract boolean hasPagination();

    public abstract void removePagination();

    public abstract Pagination getPage();

    public abstract boolean containsSearchKey(String var1);

    public abstract <T> T getValue(String var1);

    public abstract boolean hasPageable();
}

