/*
 * Decompiled with CFR 0.152.
 */
package io.aws.lambda.events;

import io.aws.lambda.events.BodyEvent;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;

public class BodyBase64Event<T extends BodyBase64Event<T>>
extends BodyEvent<T> {
    private static final Base64.Decoder DEFAULT_DECODER = Base64.getMimeDecoder();
    private boolean isBase64Encoded = false;

    public String getBodyDecoded() {
        return this.isBase64Encoded() ? this.decode(this.getBody()) : this.getBody();
    }

    public boolean isBase64Encoded() {
        return this.isBase64Encoded;
    }

    public T setBase64Encoded(boolean base64Encoded) {
        this.isBase64Encoded = base64Encoded;
        return (T)this;
    }

    protected String decode(String stringAsBase64) {
        return new String(DEFAULT_DECODER.decode(stringAsBase64), StandardCharsets.UTF_8);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BodyBase64Event that = (BodyBase64Event)o;
        return this.isBase64Encoded == that.isBase64Encoded;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isBase64Encoded);
    }

    @Override
    public String toString() {
        return "[isBase64Encoded=" + this.isBase64Encoded + "]";
    }
}

