/*
 * Decompiled with CFR 0.152.
 */
package io.aws.lambda.events.gateway;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class APIGatewayProxyResponse
implements Serializable {
    private Object body;
    private boolean isBase64Encoded = false;
    private int statusCode = 200;
    private Map<String, String> headers;
    private Map<String, List<String>> multiValueHeaders;

    @NotNull
    public Map<String, String> getHeaders() {
        return this.headers == null ? Collections.emptyMap() : this.headers;
    }

    @NotNull
    public Map<String, List<String>> getMultiValueHeaders() {
        return this.multiValueHeaders == null ? Collections.emptyMap() : this.multiValueHeaders;
    }

    public APIGatewayProxyResponse addHeader(@NotNull String name, @NotNull String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
        return this;
    }

    public APIGatewayProxyResponse addMultiHeader(@NotNull String name, @NotNull List<String> value) {
        if (this.multiValueHeaders == null) {
            this.multiValueHeaders = new HashMap<String, List<String>>();
        }
        this.multiValueHeaders.put(name, value);
        return this;
    }

    public Object getBody() {
        return this.body;
    }

    public boolean isBase64Encoded() {
        return this.isBase64Encoded;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public APIGatewayProxyResponse setBody(Object body) {
        this.body = body;
        return this;
    }

    public APIGatewayProxyResponse setBase64Encoded(boolean isBase64Encoded) {
        this.isBase64Encoded = isBase64Encoded;
        return this;
    }

    public APIGatewayProxyResponse setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public APIGatewayProxyResponse setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public APIGatewayProxyResponse setMultiValueHeaders(Map<String, List<String>> multiValueHeaders) {
        this.multiValueHeaders = multiValueHeaders;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof APIGatewayProxyResponse)) {
            return false;
        }
        APIGatewayProxyResponse other = (APIGatewayProxyResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBase64Encoded() != other.isBase64Encoded()) {
            return false;
        }
        if (this.getStatusCode() != other.getStatusCode()) {
            return false;
        }
        Object this$body = this.getBody();
        Object other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Map<String, List<String>> this$multiValueHeaders = this.getMultiValueHeaders();
        Map<String, List<String>> other$multiValueHeaders = other.getMultiValueHeaders();
        return !(this$multiValueHeaders == null ? other$multiValueHeaders != null : !((Object)this$multiValueHeaders).equals(other$multiValueHeaders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof APIGatewayProxyResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBase64Encoded() ? 79 : 97);
        result = result * 59 + this.getStatusCode();
        Object $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Map<String, List<String>> $multiValueHeaders = this.getMultiValueHeaders();
        result = result * 59 + ($multiValueHeaders == null ? 43 : ((Object)$multiValueHeaders).hashCode());
        return result;
    }

    public String toString() {
        return "APIGatewayProxyResponse(body=" + this.getBody() + ", isBase64Encoded=" + this.isBase64Encoded() + ", statusCode=" + this.getStatusCode() + ", headers=" + this.getHeaders() + ", multiValueHeaders=" + this.getMultiValueHeaders() + ")";
    }
}

