/*
 * Decompiled with CFR 0.152.
 */
package io.aws.lambda.events.gateway;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class APIGatewayV2CustomAuthorizerEvent {
    private String version;
    private String type;
    private String routeArn;
    private String routeKey;
    private String rawPath;
    private String rawQueryString;
    private List<String> identitySource;
    private List<String> cookies;
    private Map<String, String> headers;
    private Map<String, String> queryStringParameters;
    private Map<String, String> pathParameters;
    private Map<String, String> stageVariables;
    private RequestContext requestContext;

    @NotNull
    public Map<String, String> getHeaders() {
        return this.headers == null ? Collections.emptyMap() : this.headers;
    }

    @NotNull
    public Map<String, String> getQueryStringParameters() {
        return this.queryStringParameters == null ? Collections.emptyMap() : this.queryStringParameters;
    }

    @NotNull
    public Map<String, String> getPathParameters() {
        return this.pathParameters == null ? Collections.emptyMap() : this.pathParameters;
    }

    @NotNull
    public Map<String, String> getStageVariables() {
        return this.stageVariables == null ? Collections.emptyMap() : this.stageVariables;
    }

    @NotNull
    public List<String> getIdentitySource() {
        return this.identitySource == null ? Collections.emptyList() : this.identitySource;
    }

    @NotNull
    public List<String> getCookies() {
        return this.cookies == null ? Collections.emptyList() : this.cookies;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getRouteArn() {
        return this.routeArn;
    }

    public String getRouteKey() {
        return this.routeKey;
    }

    public String getRawPath() {
        return this.rawPath;
    }

    public String getRawQueryString() {
        return this.rawQueryString;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public APIGatewayV2CustomAuthorizerEvent setVersion(String version) {
        this.version = version;
        return this;
    }

    public APIGatewayV2CustomAuthorizerEvent setType(String type) {
        this.type = type;
        return this;
    }

    public APIGatewayV2CustomAuthorizerEvent setRouteArn(String routeArn) {
        this.routeArn = routeArn;
        return this;
    }

    public APIGatewayV2CustomAuthorizerEvent setRouteKey(String routeKey) {
        this.routeKey = routeKey;
        return this;
    }

    public APIGatewayV2CustomAuthorizerEvent setRawPath(String rawPath) {
        this.rawPath = rawPath;
        return this;
    }

    public APIGatewayV2CustomAuthorizerEvent setRawQueryString(String rawQueryString) {
        this.rawQueryString = rawQueryString;
        return this;
    }

    public APIGatewayV2CustomAuthorizerEvent setIdentitySource(List<String> identitySource) {
        this.identitySource = identitySource;
        return this;
    }

    public APIGatewayV2CustomAuthorizerEvent setCookies(List<String> cookies) {
        this.cookies = cookies;
        return this;
    }

    public APIGatewayV2CustomAuthorizerEvent setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public APIGatewayV2CustomAuthorizerEvent setQueryStringParameters(Map<String, String> queryStringParameters) {
        this.queryStringParameters = queryStringParameters;
        return this;
    }

    public APIGatewayV2CustomAuthorizerEvent setPathParameters(Map<String, String> pathParameters) {
        this.pathParameters = pathParameters;
        return this;
    }

    public APIGatewayV2CustomAuthorizerEvent setStageVariables(Map<String, String> stageVariables) {
        this.stageVariables = stageVariables;
        return this;
    }

    public APIGatewayV2CustomAuthorizerEvent setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof APIGatewayV2CustomAuthorizerEvent)) {
            return false;
        }
        APIGatewayV2CustomAuthorizerEvent other = (APIGatewayV2CustomAuthorizerEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$routeArn = this.getRouteArn();
        String other$routeArn = other.getRouteArn();
        if (this$routeArn == null ? other$routeArn != null : !this$routeArn.equals(other$routeArn)) {
            return false;
        }
        String this$routeKey = this.getRouteKey();
        String other$routeKey = other.getRouteKey();
        if (this$routeKey == null ? other$routeKey != null : !this$routeKey.equals(other$routeKey)) {
            return false;
        }
        String this$rawPath = this.getRawPath();
        String other$rawPath = other.getRawPath();
        if (this$rawPath == null ? other$rawPath != null : !this$rawPath.equals(other$rawPath)) {
            return false;
        }
        String this$rawQueryString = this.getRawQueryString();
        String other$rawQueryString = other.getRawQueryString();
        if (this$rawQueryString == null ? other$rawQueryString != null : !this$rawQueryString.equals(other$rawQueryString)) {
            return false;
        }
        List<String> this$identitySource = this.getIdentitySource();
        List<String> other$identitySource = other.getIdentitySource();
        if (this$identitySource == null ? other$identitySource != null : !((Object)this$identitySource).equals(other$identitySource)) {
            return false;
        }
        List<String> this$cookies = this.getCookies();
        List<String> other$cookies = other.getCookies();
        if (this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Map<String, String> this$queryStringParameters = this.getQueryStringParameters();
        Map<String, String> other$queryStringParameters = other.getQueryStringParameters();
        if (this$queryStringParameters == null ? other$queryStringParameters != null : !((Object)this$queryStringParameters).equals(other$queryStringParameters)) {
            return false;
        }
        Map<String, String> this$pathParameters = this.getPathParameters();
        Map<String, String> other$pathParameters = other.getPathParameters();
        if (this$pathParameters == null ? other$pathParameters != null : !((Object)this$pathParameters).equals(other$pathParameters)) {
            return false;
        }
        Map<String, String> this$stageVariables = this.getStageVariables();
        Map<String, String> other$stageVariables = other.getStageVariables();
        if (this$stageVariables == null ? other$stageVariables != null : !((Object)this$stageVariables).equals(other$stageVariables)) {
            return false;
        }
        RequestContext this$requestContext = this.getRequestContext();
        RequestContext other$requestContext = other.getRequestContext();
        return !(this$requestContext == null ? other$requestContext != null : !((Object)this$requestContext).equals(other$requestContext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof APIGatewayV2CustomAuthorizerEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $routeArn = this.getRouteArn();
        result = result * 59 + ($routeArn == null ? 43 : $routeArn.hashCode());
        String $routeKey = this.getRouteKey();
        result = result * 59 + ($routeKey == null ? 43 : $routeKey.hashCode());
        String $rawPath = this.getRawPath();
        result = result * 59 + ($rawPath == null ? 43 : $rawPath.hashCode());
        String $rawQueryString = this.getRawQueryString();
        result = result * 59 + ($rawQueryString == null ? 43 : $rawQueryString.hashCode());
        List<String> $identitySource = this.getIdentitySource();
        result = result * 59 + ($identitySource == null ? 43 : ((Object)$identitySource).hashCode());
        List<String> $cookies = this.getCookies();
        result = result * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Map<String, String> $queryStringParameters = this.getQueryStringParameters();
        result = result * 59 + ($queryStringParameters == null ? 43 : ((Object)$queryStringParameters).hashCode());
        Map<String, String> $pathParameters = this.getPathParameters();
        result = result * 59 + ($pathParameters == null ? 43 : ((Object)$pathParameters).hashCode());
        Map<String, String> $stageVariables = this.getStageVariables();
        result = result * 59 + ($stageVariables == null ? 43 : ((Object)$stageVariables).hashCode());
        RequestContext $requestContext = this.getRequestContext();
        result = result * 59 + ($requestContext == null ? 43 : ((Object)$requestContext).hashCode());
        return result;
    }

    public String toString() {
        return "APIGatewayV2CustomAuthorizerEvent(version=" + this.getVersion() + ", type=" + this.getType() + ", routeArn=" + this.getRouteArn() + ", routeKey=" + this.getRouteKey() + ", rawPath=" + this.getRawPath() + ", rawQueryString=" + this.getRawQueryString() + ", identitySource=" + this.getIdentitySource() + ", cookies=" + this.getCookies() + ", headers=" + this.getHeaders() + ", queryStringParameters=" + this.getQueryStringParameters() + ", pathParameters=" + this.getPathParameters() + ", stageVariables=" + this.getStageVariables() + ", requestContext=" + this.getRequestContext() + ")";
    }

    public static class Http {
        private String method;
        private String path;
        private String protocol;
        private String sourceIp;
        private String userAgent;

        public String getMethod() {
            return this.method;
        }

        public String getPath() {
            return this.path;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getSourceIp() {
            return this.sourceIp;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public Http setMethod(String method) {
            this.method = method;
            return this;
        }

        public Http setPath(String path) {
            this.path = path;
            return this;
        }

        public Http setProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Http setSourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
            return this;
        }

        public Http setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Http)) {
                return false;
            }
            Http other = (Http)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$protocol = this.getProtocol();
            String other$protocol = other.getProtocol();
            if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
                return false;
            }
            String this$sourceIp = this.getSourceIp();
            String other$sourceIp = other.getSourceIp();
            if (this$sourceIp == null ? other$sourceIp != null : !this$sourceIp.equals(other$sourceIp)) {
                return false;
            }
            String this$userAgent = this.getUserAgent();
            String other$userAgent = other.getUserAgent();
            return !(this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Http;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $protocol = this.getProtocol();
            result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
            String $sourceIp = this.getSourceIp();
            result = result * 59 + ($sourceIp == null ? 43 : $sourceIp.hashCode());
            String $userAgent = this.getUserAgent();
            result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
            return result;
        }

        public String toString() {
            return "APIGatewayV2CustomAuthorizerEvent.Http(method=" + this.getMethod() + ", path=" + this.getPath() + ", protocol=" + this.getProtocol() + ", sourceIp=" + this.getSourceIp() + ", userAgent=" + this.getUserAgent() + ")";
        }
    }

    public static class RequestContext {
        private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("dd/MMM/yyyy:HH:mm:ss Z");
        private String accountId;
        private String apiId;
        private String domainName;
        private String domainPrefix;
        private Http http;
        private String requestId;
        private String routeKey;
        private String stage;
        private String time;
        private long timeEpoch;

        public LocalDateTime getDateTime() {
            return LocalDateTime.parse(this.time, FORMATTER);
        }

        public String getAccountId() {
            return this.accountId;
        }

        public String getApiId() {
            return this.apiId;
        }

        public String getDomainName() {
            return this.domainName;
        }

        public String getDomainPrefix() {
            return this.domainPrefix;
        }

        public Http getHttp() {
            return this.http;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public String getRouteKey() {
            return this.routeKey;
        }

        public String getStage() {
            return this.stage;
        }

        public String getTime() {
            return this.time;
        }

        public long getTimeEpoch() {
            return this.timeEpoch;
        }

        public RequestContext setAccountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public RequestContext setApiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public RequestContext setDomainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public RequestContext setDomainPrefix(String domainPrefix) {
            this.domainPrefix = domainPrefix;
            return this;
        }

        public RequestContext setHttp(Http http) {
            this.http = http;
            return this;
        }

        public RequestContext setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public RequestContext setRouteKey(String routeKey) {
            this.routeKey = routeKey;
            return this;
        }

        public RequestContext setStage(String stage) {
            this.stage = stage;
            return this;
        }

        public RequestContext setTime(String time) {
            this.time = time;
            return this;
        }

        public RequestContext setTimeEpoch(long timeEpoch) {
            this.timeEpoch = timeEpoch;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestContext)) {
                return false;
            }
            RequestContext other = (RequestContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTimeEpoch() != other.getTimeEpoch()) {
                return false;
            }
            String this$accountId = this.getAccountId();
            String other$accountId = other.getAccountId();
            if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
                return false;
            }
            String this$apiId = this.getApiId();
            String other$apiId = other.getApiId();
            if (this$apiId == null ? other$apiId != null : !this$apiId.equals(other$apiId)) {
                return false;
            }
            String this$domainName = this.getDomainName();
            String other$domainName = other.getDomainName();
            if (this$domainName == null ? other$domainName != null : !this$domainName.equals(other$domainName)) {
                return false;
            }
            String this$domainPrefix = this.getDomainPrefix();
            String other$domainPrefix = other.getDomainPrefix();
            if (this$domainPrefix == null ? other$domainPrefix != null : !this$domainPrefix.equals(other$domainPrefix)) {
                return false;
            }
            Http this$http = this.getHttp();
            Http other$http = other.getHttp();
            if (this$http == null ? other$http != null : !((Object)this$http).equals(other$http)) {
                return false;
            }
            String this$requestId = this.getRequestId();
            String other$requestId = other.getRequestId();
            if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
                return false;
            }
            String this$routeKey = this.getRouteKey();
            String other$routeKey = other.getRouteKey();
            if (this$routeKey == null ? other$routeKey != null : !this$routeKey.equals(other$routeKey)) {
                return false;
            }
            String this$stage = this.getStage();
            String other$stage = other.getStage();
            if (this$stage == null ? other$stage != null : !this$stage.equals(other$stage)) {
                return false;
            }
            String this$time = this.getTime();
            String other$time = other.getTime();
            return !(this$time == null ? other$time != null : !this$time.equals(other$time));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RequestContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timeEpoch = this.getTimeEpoch();
            result = result * 59 + (int)($timeEpoch >>> 32 ^ $timeEpoch);
            String $accountId = this.getAccountId();
            result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
            String $apiId = this.getApiId();
            result = result * 59 + ($apiId == null ? 43 : $apiId.hashCode());
            String $domainName = this.getDomainName();
            result = result * 59 + ($domainName == null ? 43 : $domainName.hashCode());
            String $domainPrefix = this.getDomainPrefix();
            result = result * 59 + ($domainPrefix == null ? 43 : $domainPrefix.hashCode());
            Http $http = this.getHttp();
            result = result * 59 + ($http == null ? 43 : ((Object)$http).hashCode());
            String $requestId = this.getRequestId();
            result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
            String $routeKey = this.getRouteKey();
            result = result * 59 + ($routeKey == null ? 43 : $routeKey.hashCode());
            String $stage = this.getStage();
            result = result * 59 + ($stage == null ? 43 : $stage.hashCode());
            String $time = this.getTime();
            result = result * 59 + ($time == null ? 43 : $time.hashCode());
            return result;
        }

        public String toString() {
            return "APIGatewayV2CustomAuthorizerEvent.RequestContext(accountId=" + this.getAccountId() + ", apiId=" + this.getApiId() + ", domainName=" + this.getDomainName() + ", domainPrefix=" + this.getDomainPrefix() + ", http=" + this.getHttp() + ", requestId=" + this.getRequestId() + ", routeKey=" + this.getRouteKey() + ", stage=" + this.getStage() + ", time=" + this.getTime() + ", timeEpoch=" + this.getTimeEpoch() + ")";
        }
    }
}

