/*
 * Decompiled with CFR 0.152.
 */
package io.aws.lambda.events.s3;

import io.aws.lambda.events.s3.S3BatchEvent;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class S3BatchResponse {
    private String invocationSchemaVersion;
    private ResultCode treatMissingKeysAs;
    private String invocationId;
    private List<Result> results;

    @NotNull
    public List<Result> getResults() {
        return this.results == null ? Collections.emptyList() : this.results;
    }

    public static S3BatchResponse fromS3BatchEvent(S3BatchEvent s3BatchEvent) {
        return new S3BatchResponse().setInvocationId(s3BatchEvent.getInvocationId()).setInvocationSchemaVersion(s3BatchEvent.getInvocationSchemaVersion());
    }

    public String getInvocationSchemaVersion() {
        return this.invocationSchemaVersion;
    }

    public ResultCode getTreatMissingKeysAs() {
        return this.treatMissingKeysAs;
    }

    public String getInvocationId() {
        return this.invocationId;
    }

    public S3BatchResponse setInvocationSchemaVersion(String invocationSchemaVersion) {
        this.invocationSchemaVersion = invocationSchemaVersion;
        return this;
    }

    public S3BatchResponse setTreatMissingKeysAs(ResultCode treatMissingKeysAs) {
        this.treatMissingKeysAs = treatMissingKeysAs;
        return this;
    }

    public S3BatchResponse setInvocationId(String invocationId) {
        this.invocationId = invocationId;
        return this;
    }

    public S3BatchResponse setResults(List<Result> results) {
        this.results = results;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof S3BatchResponse)) {
            return false;
        }
        S3BatchResponse other = (S3BatchResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$invocationSchemaVersion = this.getInvocationSchemaVersion();
        String other$invocationSchemaVersion = other.getInvocationSchemaVersion();
        if (this$invocationSchemaVersion == null ? other$invocationSchemaVersion != null : !this$invocationSchemaVersion.equals(other$invocationSchemaVersion)) {
            return false;
        }
        ResultCode this$treatMissingKeysAs = this.getTreatMissingKeysAs();
        ResultCode other$treatMissingKeysAs = other.getTreatMissingKeysAs();
        if (this$treatMissingKeysAs == null ? other$treatMissingKeysAs != null : !((Object)((Object)this$treatMissingKeysAs)).equals((Object)other$treatMissingKeysAs)) {
            return false;
        }
        String this$invocationId = this.getInvocationId();
        String other$invocationId = other.getInvocationId();
        if (this$invocationId == null ? other$invocationId != null : !this$invocationId.equals(other$invocationId)) {
            return false;
        }
        List<Result> this$results = this.getResults();
        List<Result> other$results = other.getResults();
        return !(this$results == null ? other$results != null : !((Object)this$results).equals(other$results));
    }

    protected boolean canEqual(Object other) {
        return other instanceof S3BatchResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $invocationSchemaVersion = this.getInvocationSchemaVersion();
        result = result * 59 + ($invocationSchemaVersion == null ? 43 : $invocationSchemaVersion.hashCode());
        ResultCode $treatMissingKeysAs = this.getTreatMissingKeysAs();
        result = result * 59 + ($treatMissingKeysAs == null ? 43 : ((Object)((Object)$treatMissingKeysAs)).hashCode());
        String $invocationId = this.getInvocationId();
        result = result * 59 + ($invocationId == null ? 43 : $invocationId.hashCode());
        List<Result> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        return result;
    }

    public String toString() {
        return "S3BatchResponse(invocationSchemaVersion=" + this.getInvocationSchemaVersion() + ", treatMissingKeysAs=" + this.getTreatMissingKeysAs() + ", invocationId=" + this.getInvocationId() + ", results=" + this.getResults() + ")";
    }

    public static class Result {
        private String taskId;
        private ResultCode resultCode;
        private String resultString;

        public String getTaskId() {
            return this.taskId;
        }

        public ResultCode getResultCode() {
            return this.resultCode;
        }

        public String getResultString() {
            return this.resultString;
        }

        public Result setTaskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Result setResultCode(ResultCode resultCode) {
            this.resultCode = resultCode;
            return this;
        }

        public Result setResultString(String resultString) {
            this.resultString = resultString;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$taskId = this.getTaskId();
            String other$taskId = other.getTaskId();
            if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
                return false;
            }
            ResultCode this$resultCode = this.getResultCode();
            ResultCode other$resultCode = other.getResultCode();
            if (this$resultCode == null ? other$resultCode != null : !((Object)((Object)this$resultCode)).equals((Object)other$resultCode)) {
                return false;
            }
            String this$resultString = this.getResultString();
            String other$resultString = other.getResultString();
            return !(this$resultString == null ? other$resultString != null : !this$resultString.equals(other$resultString));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $taskId = this.getTaskId();
            result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
            ResultCode $resultCode = this.getResultCode();
            result = result * 59 + ($resultCode == null ? 43 : ((Object)((Object)$resultCode)).hashCode());
            String $resultString = this.getResultString();
            result = result * 59 + ($resultString == null ? 43 : $resultString.hashCode());
            return result;
        }

        public String toString() {
            return "S3BatchResponse.Result(taskId=" + this.getTaskId() + ", resultCode=" + this.getResultCode() + ", resultString=" + this.getResultString() + ")";
        }
    }

    public static enum ResultCode {
        Succeeded,
        TemporaryFailure,
        PermanentFailure;

    }
}

