/*
 * Decompiled with CFR 0.152.
 */
package io.aws.lambda.events.system;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class IamPolicyResponse
implements Serializable {
    public static final String EXECUTE_API_INVOKE = "execute-api:Invoke";
    public static final String VERSION_2012_10_17 = "2012-10-17";
    public static final String ALLOW = "Allow";
    public static final String DENY = "Deny";
    private String principalId;
    private PolicyDocument policyDocument;
    private Map<String, Object> context;

    @NotNull
    public Map<String, Object> getContext() {
        return this.context == null ? Collections.emptyMap() : this.context;
    }

    public Map<String, Object> getPolicyDocument() {
        List statements = this.policyDocument.getStatement().stream().map(statement -> Map.of("Effect", statement.getEffect(), "Action", statement.getAction(), "Resource", statement.getResource().toArray(new String[0]), "Condition", statement.getCondition())).collect(Collectors.toList());
        return Map.of("Version", this.policyDocument.getVersion(), "Statement", statements);
    }

    public static Statement allowStatement(String resource) {
        return new Statement().setEffect(ALLOW).setResource(Collections.singletonList(resource)).setAction(EXECUTE_API_INVOKE);
    }

    public static Statement denyStatement(String resource) {
        return new Statement().setEffect(DENY).setResource(Collections.singletonList(resource)).setAction(EXECUTE_API_INVOKE);
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public IamPolicyResponse setPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    public IamPolicyResponse setPolicyDocument(PolicyDocument policyDocument) {
        this.policyDocument = policyDocument;
        return this;
    }

    public IamPolicyResponse setContext(Map<String, Object> context) {
        this.context = context;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IamPolicyResponse)) {
            return false;
        }
        IamPolicyResponse other = (IamPolicyResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$principalId = this.getPrincipalId();
        String other$principalId = other.getPrincipalId();
        if (this$principalId == null ? other$principalId != null : !this$principalId.equals(other$principalId)) {
            return false;
        }
        Map<String, Object> this$policyDocument = this.getPolicyDocument();
        Map<String, Object> other$policyDocument = other.getPolicyDocument();
        if (this$policyDocument == null ? other$policyDocument != null : !((Object)this$policyDocument).equals(other$policyDocument)) {
            return false;
        }
        Map<String, Object> this$context = this.getContext();
        Map<String, Object> other$context = other.getContext();
        return !(this$context == null ? other$context != null : !((Object)this$context).equals(other$context));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IamPolicyResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $principalId = this.getPrincipalId();
        result = result * 59 + ($principalId == null ? 43 : $principalId.hashCode());
        Map<String, Object> $policyDocument = this.getPolicyDocument();
        result = result * 59 + ($policyDocument == null ? 43 : ((Object)$policyDocument).hashCode());
        Map<String, Object> $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        return result;
    }

    public String toString() {
        return "IamPolicyResponse(principalId=" + this.getPrincipalId() + ", policyDocument=" + this.getPolicyDocument() + ", context=" + this.getContext() + ")";
    }

    public static class Statement
    implements Serializable {
        private String action;
        private String effect;
        private List<String> resource;
        private Map<String, Map<String, Object>> condition;

        @NotNull
        public List<String> getResource() {
            return this.resource == null ? Collections.emptyList() : this.resource;
        }

        @NotNull
        public Map<String, Map<String, Object>> getCondition() {
            return this.condition == null ? Collections.emptyMap() : this.condition;
        }

        public String getAction() {
            return this.action;
        }

        public String getEffect() {
            return this.effect;
        }

        public Statement setAction(String action) {
            this.action = action;
            return this;
        }

        public Statement setEffect(String effect) {
            this.effect = effect;
            return this;
        }

        public Statement setResource(List<String> resource) {
            this.resource = resource;
            return this;
        }

        public Statement setCondition(Map<String, Map<String, Object>> condition) {
            this.condition = condition;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Statement)) {
                return false;
            }
            Statement other = (Statement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$action = this.getAction();
            String other$action = other.getAction();
            if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
                return false;
            }
            String this$effect = this.getEffect();
            String other$effect = other.getEffect();
            if (this$effect == null ? other$effect != null : !this$effect.equals(other$effect)) {
                return false;
            }
            List<String> this$resource = this.getResource();
            List<String> other$resource = other.getResource();
            if (this$resource == null ? other$resource != null : !((Object)this$resource).equals(other$resource)) {
                return false;
            }
            Map<String, Map<String, Object>> this$condition = this.getCondition();
            Map<String, Map<String, Object>> other$condition = other.getCondition();
            return !(this$condition == null ? other$condition != null : !((Object)this$condition).equals(other$condition));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Statement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            String $effect = this.getEffect();
            result = result * 59 + ($effect == null ? 43 : $effect.hashCode());
            List<String> $resource = this.getResource();
            result = result * 59 + ($resource == null ? 43 : ((Object)$resource).hashCode());
            Map<String, Map<String, Object>> $condition = this.getCondition();
            result = result * 59 + ($condition == null ? 43 : ((Object)$condition).hashCode());
            return result;
        }

        public String toString() {
            return "IamPolicyResponse.Statement(action=" + this.getAction() + ", effect=" + this.getEffect() + ", resource=" + this.getResource() + ", condition=" + this.getCondition() + ")";
        }
    }

    public static class PolicyDocument
    implements Serializable {
        private String version;
        private List<Statement> statement;

        @NotNull
        public List<Statement> getStatement() {
            return this.statement == null ? Collections.emptyList() : this.statement;
        }

        public String getVersion() {
            return this.version;
        }

        public PolicyDocument setVersion(String version) {
            this.version = version;
            return this;
        }

        public PolicyDocument setStatement(List<Statement> statement) {
            this.statement = statement;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PolicyDocument)) {
                return false;
            }
            PolicyDocument other = (PolicyDocument)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            List<Statement> this$statement = this.getStatement();
            List<Statement> other$statement = other.getStatement();
            return !(this$statement == null ? other$statement != null : !((Object)this$statement).equals(other$statement));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PolicyDocument;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            List<Statement> $statement = this.getStatement();
            result = result * 59 + ($statement == null ? 43 : ((Object)$statement).hashCode());
            return result;
        }

        public String toString() {
            return "IamPolicyResponse.PolicyDocument(version=" + this.getVersion() + ", statement=" + this.getStatement() + ")";
        }
    }
}

