/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.core.impl;

import io.api.etherscan.core.IBlockApi;
import io.api.etherscan.core.impl.BasicProvider;
import io.api.etherscan.error.ApiException;
import io.api.etherscan.executor.IHttpExecutor;
import io.api.etherscan.manager.IQueueManager;
import io.api.etherscan.model.UncleBlock;
import io.api.etherscan.model.utility.UncleBlockResponseTO;
import io.api.etherscan.util.BasicUtils;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class BlockApiProvider
extends BasicProvider
implements IBlockApi {
    private static final String ACT_BLOCK_PARAM = "&action=getblockreward";
    private static final String BLOCKNO_PARAM = "&blockno=";

    BlockApiProvider(IQueueManager queueManager, String baseUrl, IHttpExecutor executor) {
        super(queueManager, "block", baseUrl, executor);
    }

    @Override
    @NotNull
    public Optional<UncleBlock> uncles(long blockNumber) throws ApiException {
        String urlParam = "&action=getblockreward&blockno=" + blockNumber;
        String response = this.getRequest(urlParam);
        if (BasicUtils.isEmpty(response) || response.contains("NOTOK")) {
            return Optional.empty();
        }
        UncleBlockResponseTO responseTO = this.convert(response, UncleBlockResponseTO.class);
        BasicUtils.validateTxResponse(responseTO);
        return responseTO.getResult() == null || responseTO.getResult().isEmpty() ? Optional.empty() : Optional.of(responseTO.getResult());
    }
}

