/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.model;

import io.api.etherscan.util.BasicUtils;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

abstract class BaseTx {
    private long blockNumber;
    private String timeStamp;
    private LocalDateTime _timeStamp;
    private String hash;
    private String from;
    private String to;
    private BigInteger value;
    private String contractAddress;
    private String input;
    private BigInteger gas;
    private BigInteger gasUsed;

    BaseTx() {
    }

    public long getBlockNumber() {
        return this.blockNumber;
    }

    public LocalDateTime getTimeStamp() {
        if (this._timeStamp == null && !BasicUtils.isEmpty(this.timeStamp)) {
            this._timeStamp = LocalDateTime.ofEpochSecond(Long.valueOf(this.timeStamp), 0, ZoneOffset.UTC);
        }
        return this._timeStamp;
    }

    public String getHash() {
        return this.hash;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public String getInput() {
        return this.input;
    }

    public BigInteger getGas() {
        return this.gas;
    }

    public BigInteger getGasUsed() {
        return this.gasUsed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseTx baseTx = (BaseTx)o;
        return this.hash != null ? this.hash.equals(baseTx.hash) : baseTx.hash == null;
    }

    public int hashCode() {
        return this.hash != null ? this.hash.hashCode() : 0;
    }
}

