/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.model;

import io.api.etherscan.util.BasicUtils;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;

public class Log {
    private String blockNumber;
    private Long _blockNumber;
    private String address;
    private String transactionHash;
    private String transactionIndex;
    private Long _transactionIndex;
    private String timeStamp;
    private LocalDateTime _timeStamp;
    private String data;
    private String gasPrice;
    private BigInteger _gasPrice;
    private String gasUsed;
    private BigInteger _gasUsed;
    private List<String> topics;
    private String logIndex;
    private Long _logIndex;

    public Long getBlockNumber() {
        if (this._blockNumber == null && !BasicUtils.isEmpty(this.blockNumber)) {
            this._blockNumber = BasicUtils.parseHex(this.blockNumber).longValue();
        }
        return this._blockNumber;
    }

    public String getAddress() {
        return this.address;
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public Long getTransactionIndex() {
        if (this._transactionIndex == null && !BasicUtils.isEmpty(this.transactionIndex)) {
            this._transactionIndex = BasicUtils.parseHex(this.transactionIndex).longValue();
        }
        return this._transactionIndex;
    }

    public LocalDateTime getTimeStamp() {
        if (this._timeStamp == null && !BasicUtils.isEmpty(this.timeStamp)) {
            long formatted = this.timeStamp.charAt(0) == '0' && this.timeStamp.charAt(1) == 'x' ? BasicUtils.parseHex(this.timeStamp).longValue() : Long.valueOf(this.timeStamp).longValue();
            this._timeStamp = LocalDateTime.ofEpochSecond(formatted, 0, ZoneOffset.UTC);
        }
        return this._timeStamp;
    }

    public String getData() {
        return this.data;
    }

    public BigInteger getGasPrice() {
        if (!BasicUtils.isEmpty(this.gasPrice)) {
            this._gasPrice = BasicUtils.parseHex(this.gasPrice);
        }
        return this._gasPrice;
    }

    public BigInteger getGasUsed() {
        if (!BasicUtils.isEmpty(this.gasUsed)) {
            this._gasUsed = BasicUtils.parseHex(this.gasUsed);
        }
        return this._gasUsed;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public Long getLogIndex() {
        if (this._logIndex == null && !BasicUtils.isEmpty(this.logIndex)) {
            this._logIndex = BasicUtils.parseHex(this.logIndex).longValue();
        }
        return this._logIndex;
    }
}

