/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.model.proxy;

import io.api.etherscan.model.Log;
import io.api.etherscan.util.BasicUtils;
import java.math.BigInteger;
import java.util.List;

public class ReceiptProxy {
    private String root;
    private String from;
    private String to;
    private String blockNumber;
    private Long _blockNumber;
    private String blockHash;
    private String transactionHash;
    private String transactionIndex;
    private Long _transactionIndex;
    private String gasUsed;
    private BigInteger _gasUsed;
    private String cumulativeGasUsed;
    private BigInteger _cumulativeGasUsed;
    private String contractAddress;
    private List<Log> logs;
    private String logsBloom;

    public String getRoot() {
        return this.root;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public Long getBlockNumber() {
        if (this._blockNumber == null && !BasicUtils.isEmpty(this.blockNumber)) {
            this._blockNumber = BasicUtils.parseHex(this.blockNumber).longValue();
        }
        return this._blockNumber;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public Long getTransactionIndex() {
        if (this._transactionIndex == null && !BasicUtils.isEmpty(this.transactionIndex)) {
            this._transactionIndex = BasicUtils.parseHex(this.transactionIndex).longValue();
        }
        return this._transactionIndex;
    }

    public BigInteger getGasUsed() {
        if (this._gasUsed == null && !BasicUtils.isEmpty(this.gasUsed)) {
            this._gasUsed = BasicUtils.parseHex(this.gasUsed);
        }
        return this._gasUsed;
    }

    public BigInteger getCumulativeGasUsed() {
        if (this._cumulativeGasUsed == null && !BasicUtils.isEmpty(this.cumulativeGasUsed)) {
            this._cumulativeGasUsed = BasicUtils.parseHex(this.cumulativeGasUsed);
        }
        return this._cumulativeGasUsed;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public List<Log> getLogs() {
        return this.logs;
    }

    public String getLogsBloom() {
        return this.logsBloom;
    }
}

