/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.model;

import io.api.etherscan.model.BaseTx;
import io.api.etherscan.util.BasicUtils;
import java.math.BigInteger;

public class Tx
extends BaseTx {
    private long nonce;
    private String blockHash;
    private int transactionIndex;
    private BigInteger gasPrice;
    private BigInteger cumulativeGasUsed;
    private long confirmations;
    private String isError;
    private String txreceipt_status;

    public long getNonce() {
        return this.nonce;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public int getTransactionIndex() {
        return this.transactionIndex;
    }

    public BigInteger getGasPrice() {
        return this.gasPrice;
    }

    public boolean haveError() {
        return !BasicUtils.isEmpty(this.isError) && !this.isError.equals("0");
    }

    public String getTxreceipt_status() {
        return this.txreceipt_status;
    }

    public BigInteger getCumulativeGasUsed() {
        return this.cumulativeGasUsed;
    }

    public long getConfirmations() {
        return this.confirmations;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Tx tx = (Tx)o;
        if (this.nonce != tx.nonce) {
            return false;
        }
        if (this.transactionIndex != tx.transactionIndex) {
            return false;
        }
        if (this.blockHash != null ? !this.blockHash.equals(tx.blockHash) : tx.blockHash != null) {
            return false;
        }
        return this.isError != null ? this.isError.equals(tx.isError) : tx.isError == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.nonce ^ this.nonce >>> 32);
        result = 31 * result + (this.blockHash != null ? this.blockHash.hashCode() : 0);
        result = 31 * result + this.transactionIndex;
        result = 31 * result + (this.isError != null ? this.isError.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Tx{nonce=" + this.nonce + ", blockHash='" + this.blockHash + '\'' + ", transactionIndex=" + this.transactionIndex + ", gasPrice=" + this.gasPrice + ", cumulativeGasUsed=" + this.cumulativeGasUsed + ", confirmations=" + this.confirmations + ", isError='" + this.isError + '\'' + ", txreceipt_status='" + this.txreceipt_status + '\'' + "} " + super.toString();
    }
}

