/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.core.impl;

import io.api.etherscan.core.IStatisticApi;
import io.api.etherscan.core.impl.BasicProvider;
import io.api.etherscan.error.ApiException;
import io.api.etherscan.error.EtherScanException;
import io.api.etherscan.executor.IHttpExecutor;
import io.api.etherscan.manager.IQueueManager;
import io.api.etherscan.model.Price;
import io.api.etherscan.model.Supply;
import io.api.etherscan.model.utility.PriceResponseTO;
import io.api.etherscan.model.utility.StringResponseTO;
import io.api.etherscan.util.BasicUtils;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;

public class StatisticApiProvider
extends BasicProvider
implements IStatisticApi {
    private static final String ACT_SUPPLY_PARAM = "&action=ethsupply";
    private static final String ACT_TOKEN_SUPPLY_PARAM = "&action=tokensupply";
    private static final String ACT_LASTPRICE_PARAM = "&action=ethprice";
    private static final String CONTRACT_ADDRESS_PARAM = "&contractaddress=";

    StatisticApiProvider(IQueueManager queue, String baseUrl, IHttpExecutor executor) {
        super(queue, "stats", baseUrl, executor);
    }

    @Override
    @NotNull
    public Supply supply() throws ApiException {
        StringResponseTO response = this.getRequest(ACT_SUPPLY_PARAM, StringResponseTO.class);
        if (response.getStatus() != 1) {
            throw new EtherScanException(response);
        }
        return new Supply(new BigInteger(response.getResult()));
    }

    @Override
    @NotNull
    public BigInteger supply(String contract) throws ApiException {
        BasicUtils.validateAddress(contract);
        String urlParams = "&action=tokensupply&contractaddress=" + contract;
        StringResponseTO response = this.getRequest(urlParams, StringResponseTO.class);
        if (response.getStatus() != 1) {
            throw new EtherScanException(response);
        }
        return new BigInteger(response.getResult());
    }

    @Override
    @NotNull
    public Price lastPrice() throws ApiException {
        PriceResponseTO response = this.getRequest(ACT_LASTPRICE_PARAM, PriceResponseTO.class);
        if (response.getStatus() != 1) {
            throw new EtherScanException(response);
        }
        return response.getResult();
    }
}

