/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.model.query.impl;

import io.api.etherscan.error.LogQueryException;
import io.api.etherscan.model.query.IQueryBuilder;
import io.api.etherscan.model.query.impl.LogQuery;
import io.api.etherscan.model.query.impl.LogTopicQuadro;
import io.api.etherscan.model.query.impl.LogTopicSingle;
import io.api.etherscan.model.query.impl.LogTopicTriple;
import io.api.etherscan.model.query.impl.LogTopicTuple;
import io.api.etherscan.util.BasicUtils;

public class LogQueryBuilder
implements IQueryBuilder {
    private static final long MIN_BLOCK = 0L;
    private static final long MAX_BLOCK = 99999999999L;
    private final String address;
    private final long startBlock;
    private final long endBlock;

    private LogQueryBuilder(String address, long startBlock, long endBlock) {
        this.address = address;
        this.startBlock = startBlock;
        this.endBlock = endBlock;
    }

    public static LogQueryBuilder with(String address) {
        return LogQueryBuilder.with(address, 0L);
    }

    public static LogQueryBuilder with(String address, long startBlock) {
        return LogQueryBuilder.with(address, startBlock, 99999999999L);
    }

    public static LogQueryBuilder with(String address, long startBlock, long endBlock) {
        BasicUtils.validateAddress(address);
        return new LogQueryBuilder(address, startBlock, endBlock);
    }

    public LogTopicSingle topic(String topic0) {
        if (BasicUtils.isNotHex(topic0)) {
            throw new LogQueryException("topic0 can not be empty or non hex.");
        }
        return new LogTopicSingle(this.address, this.startBlock, this.endBlock, topic0);
    }

    public LogTopicTuple topic(String topic0, String topic1) {
        if (BasicUtils.isNotHex(topic0)) {
            throw new LogQueryException("topic0 can not be empty or non hex.");
        }
        if (BasicUtils.isNotHex(topic1)) {
            throw new LogQueryException("topic1 can not be empty or non hex.");
        }
        return new LogTopicTuple(this.address, this.startBlock, this.endBlock, topic0, topic1);
    }

    public LogTopicTriple topic(String topic0, String topic1, String topic2) {
        if (BasicUtils.isNotHex(topic0)) {
            throw new LogQueryException("topic0 can not be empty or non hex.");
        }
        if (BasicUtils.isNotHex(topic1)) {
            throw new LogQueryException("topic1 can not be empty or non hex.");
        }
        if (BasicUtils.isNotHex(topic2)) {
            throw new LogQueryException("topic2 can not be empty or non hex.");
        }
        return new LogTopicTriple(this.address, this.startBlock, this.endBlock, topic0, topic1, topic2);
    }

    public LogTopicQuadro topic(String topic0, String topic1, String topic2, String topic3) {
        if (BasicUtils.isNotHex(topic0)) {
            throw new LogQueryException("topic0 can not be empty or non hex.");
        }
        if (BasicUtils.isNotHex(topic1)) {
            throw new LogQueryException("topic1 can not be empty or non hex.");
        }
        if (BasicUtils.isNotHex(topic2)) {
            throw new LogQueryException("topic2 can not be empty or non hex.");
        }
        if (BasicUtils.isNotHex(topic3)) {
            throw new LogQueryException("topic3 can not be empty or non hex.");
        }
        return new LogTopicQuadro(this.address, this.startBlock, this.endBlock, topic0, topic1, topic2, topic3);
    }

    @Override
    public LogQuery build() throws LogQueryException {
        return new LogQuery("&address=" + this.address + "&fromBlock=" + this.startBlock + "&toBlock=" + this.endBlock);
    }
}

