/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.model;

import io.api.etherscan.util.BasicUtils;

public class Abi {
    private String contractAbi;
    private boolean isVerified;

    private Abi(String contractAbi, boolean isVerified) {
        this.contractAbi = contractAbi;
        this.isVerified = isVerified;
    }

    public static Abi verified(String contractAbi) {
        return new Abi(contractAbi, true);
    }

    public static Abi nonVerified() {
        return new Abi("", false);
    }

    public boolean haveAbi() {
        return !BasicUtils.isEmpty(this.contractAbi);
    }

    public String getContractAbi() {
        return this.contractAbi;
    }

    public boolean isVerified() {
        return this.isVerified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Abi abi = (Abi)o;
        if (this.isVerified != abi.isVerified) {
            return false;
        }
        return this.contractAbi != null ? this.contractAbi.equals(abi.contractAbi) : abi.contractAbi == null;
    }

    public int hashCode() {
        int result = this.contractAbi != null ? this.contractAbi.hashCode() : 0;
        result = 31 * result + (this.isVerified ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Abi{contractAbi='" + this.contractAbi + '\'' + ", isVerified=" + this.isVerified + '}';
    }
}

