/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.core.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import io.api.etherscan.error.ApiException;
import io.api.etherscan.error.EtherScanException;
import io.api.etherscan.error.ParseException;
import io.api.etherscan.error.RateLimitException;
import io.api.etherscan.executor.IHttpExecutor;
import io.api.etherscan.manager.IQueueManager;
import io.api.etherscan.model.utility.StringResponseTO;
import io.api.etherscan.util.BasicUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Map;

abstract class BasicProvider {
    static final int MAX_END_BLOCK = Integer.MAX_VALUE;
    static final int MIN_START_BLOCK = 0;
    static final String ACT_PREFIX = "&action=";
    private final String module;
    private final String baseUrl;
    private final IHttpExecutor executor;
    private final IQueueManager queue;
    private final Gson gson;

    BasicProvider(IQueueManager queue, String module, String baseUrl, IHttpExecutor executor) {
        this.queue = queue;
        this.module = "&module=" + module;
        this.baseUrl = baseUrl;
        this.executor = executor;
        this.gson = new GsonBuilder().registerTypeAdapter(LocalDateTime.class, (src, t, c) -> new JsonPrimitive("")).registerTypeAdapter(LocalDate.class, (src, t, context) -> new JsonPrimitive("")).registerTypeAdapter(LocalDateTime.class, (json, t, c) -> null).registerTypeAdapter(LocalDate.class, (json, t, c) -> null).create();
    }

    <T> T convert(String json, Class<T> tClass) {
        try {
            Object t = this.gson.fromJson(json, tClass);
            if (t instanceof StringResponseTO && ((StringResponseTO)t).getResult().startsWith("Max rate limit reached")) {
                throw new RateLimitException(((StringResponseTO)t).getResult());
            }
            return (T)t;
        }
        catch (Exception e) {
            try {
                Map map = (Map)this.gson.fromJson(json, Map.class);
                Object result = map.get("result");
                if (result instanceof String && ((String)result).startsWith("Max rate limit reached")) {
                    throw new RateLimitException((String)result);
                }
                throw new ParseException(e.getMessage() + ", for response: " + json, e.getCause(), json);
            }
            catch (ApiException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ParseException(e.getMessage() + ", for response: " + json, e.getCause(), json);
            }
        }
    }

    String getRequest(String urlParameters) {
        this.queue.takeTurn();
        String url = this.baseUrl + this.module + urlParameters;
        String result = this.executor.get(url);
        if (BasicUtils.isEmpty(result)) {
            throw new EtherScanException("Server returned null value for GET request at URL - " + url);
        }
        return result;
    }

    String postRequest(String urlParameters, String dataToPost) {
        this.queue.takeTurn();
        String url = this.baseUrl + this.module + urlParameters;
        return this.executor.post(url, dataToPost);
    }

    <T> T getRequest(String urlParameters, Class<T> tClass) {
        return this.convert(this.getRequest(urlParameters), tClass);
    }

    <T> T postRequest(String urlParameters, String dataToPost, Class<T> tClass) {
        return this.convert(this.postRequest(urlParameters, dataToPost), tClass);
    }
}

