/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.model;

import com.google.gson.annotations.Expose;
import io.api.etherscan.util.BasicUtils;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Objects;

public class Log {
    private String blockNumber;
    @Expose(serialize=false, deserialize=false)
    private Long _blockNumber;
    private String address;
    private String transactionHash;
    private String transactionIndex;
    @Expose(serialize=false, deserialize=false)
    private Long _transactionIndex;
    private String timeStamp;
    @Expose(serialize=false, deserialize=false)
    private LocalDateTime _timeStamp;
    private String data;
    private String gasPrice;
    @Expose(serialize=false, deserialize=false)
    private BigInteger _gasPrice;
    private String gasUsed;
    @Expose(serialize=false, deserialize=false)
    private BigInteger _gasUsed;
    private List<String> topics;
    private String logIndex;
    @Expose(serialize=false, deserialize=false)
    private Long _logIndex;

    public Long getBlockNumber() {
        if (this._blockNumber == null && !BasicUtils.isEmpty(this.blockNumber)) {
            this._blockNumber = BasicUtils.parseHex(this.blockNumber).longValue();
        }
        return this._blockNumber;
    }

    public String getAddress() {
        return this.address;
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public Long getTransactionIndex() {
        if (this._transactionIndex == null && !BasicUtils.isEmpty(this.transactionIndex)) {
            this._transactionIndex = BasicUtils.parseHex(this.transactionIndex).longValue();
        }
        return this._transactionIndex;
    }

    public LocalDateTime getTimeStamp() {
        if (this._timeStamp == null && !BasicUtils.isEmpty(this.timeStamp)) {
            long formatted = this.timeStamp.charAt(0) == '0' && this.timeStamp.charAt(1) == 'x' ? BasicUtils.parseHex(this.timeStamp).longValue() : Long.parseLong(this.timeStamp);
            this._timeStamp = LocalDateTime.ofEpochSecond(formatted, 0, ZoneOffset.UTC);
        }
        return this._timeStamp;
    }

    public Long getTimeStampAsMillis() {
        if (BasicUtils.isEmpty(this.timeStamp)) {
            return null;
        }
        long tsSecs = this.timeStamp.charAt(0) == '0' && this.timeStamp.charAt(1) == 'x' ? BasicUtils.parseHex(this.timeStamp).longValue() : Long.parseLong(this.timeStamp);
        return tsSecs * 1000L;
    }

    public String getData() {
        return this.data;
    }

    public BigInteger getGasPrice() {
        if (!BasicUtils.isEmpty(this.gasPrice)) {
            this._gasPrice = BasicUtils.parseHex(this.gasPrice);
        }
        return this._gasPrice;
    }

    public BigInteger getGasUsed() {
        if (!BasicUtils.isEmpty(this.gasUsed)) {
            this._gasUsed = BasicUtils.parseHex(this.gasUsed);
        }
        return this._gasUsed;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public Long getLogIndex() {
        if (this._logIndex == null && !BasicUtils.isEmpty(this.logIndex)) {
            this._logIndex = BasicUtils.parseHex(this.logIndex).longValue();
        }
        return this._logIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Log log = (Log)o;
        if (!Objects.equals(this.blockNumber, log.blockNumber)) {
            return false;
        }
        if (!Objects.equals(this.address, log.address)) {
            return false;
        }
        if (!Objects.equals(this.transactionHash, log.transactionHash)) {
            return false;
        }
        if (!Objects.equals(this.timeStamp, log.timeStamp)) {
            return false;
        }
        return Objects.equals(this.logIndex, log.logIndex);
    }

    public int hashCode() {
        int result = this.blockNumber != null ? this.blockNumber.hashCode() : 0;
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + (this.transactionHash != null ? this.transactionHash.hashCode() : 0);
        result = 31 * result + (this.timeStamp != null ? this.timeStamp.hashCode() : 0);
        result = 31 * result + (this.logIndex != null ? this.logIndex.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Log{blockNumber='" + this.blockNumber + '\'' + ", _blockNumber=" + this._blockNumber + ", address='" + this.address + '\'' + ", transactionHash='" + this.transactionHash + '\'' + ", transactionIndex='" + this.transactionIndex + '\'' + ", _transactionIndex=" + this._transactionIndex + ", timeStamp='" + this.timeStamp + '\'' + ", _timeStamp=" + this._timeStamp + ", data='" + this.data + '\'' + ", gasPrice='" + this.gasPrice + '\'' + ", _gasPrice=" + this._gasPrice + ", gasUsed='" + this.gasUsed + '\'' + ", _gasUsed=" + this._gasUsed + ", topics=" + this.topics + ", logIndex='" + this.logIndex + '\'' + ", _logIndex=" + this._logIndex + '}';
    }
}

