/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.model;

import com.google.gson.annotations.Expose;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Objects;

public class Price {
    private BigDecimal ethusd;
    private BigDecimal ethbtc;
    private String ethusd_timestamp;
    private String ethbtc_timestamp;
    @Expose(deserialize=false, serialize=false)
    private LocalDateTime _ethusd_timestamp;
    @Expose(deserialize=false, serialize=false)
    private LocalDateTime _ethbtc_timestamp;

    protected Price() {
    }

    public BigDecimal inUsd() {
        return this.ethusd;
    }

    public BigDecimal inBtc() {
        return this.ethbtc;
    }

    public LocalDateTime timestampUsd() {
        if (this._ethusd_timestamp == null && this.ethusd_timestamp != null) {
            this._ethusd_timestamp = LocalDateTime.ofEpochSecond(Long.parseLong(this.ethusd_timestamp), 0, ZoneOffset.UTC);
        }
        return this._ethusd_timestamp;
    }

    public LocalDateTime timestampBtc() {
        if (this._ethbtc_timestamp == null && this.ethbtc_timestamp != null) {
            this._ethbtc_timestamp = LocalDateTime.ofEpochSecond(Long.parseLong(this.ethbtc_timestamp), 0, ZoneOffset.UTC);
        }
        return this._ethbtc_timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Price)) {
            return false;
        }
        Price price = (Price)o;
        return Objects.equals(this.ethusd, price.ethusd) && Objects.equals(this.ethbtc, price.ethbtc) && Objects.equals(this.ethusd_timestamp, price.ethusd_timestamp) && Objects.equals(this.ethbtc_timestamp, price.ethbtc_timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.ethusd, this.ethbtc, this.ethusd_timestamp, this.ethbtc_timestamp);
    }

    public String toString() {
        return "Price{ethusd=" + this.ethusd + ", ethbtc=" + this.ethbtc + ", ethusd_timestamp='" + this.ethusd_timestamp + '\'' + ", ethbtc_timestamp='" + this.ethbtc_timestamp + '\'' + '}';
    }

    public static PriceBuilder builder() {
        return new PriceBuilder();
    }

    public static final class PriceBuilder {
        private BigDecimal ethusd;
        private BigDecimal ethbtc;
        private LocalDateTime ethusdTimestamp;
        private LocalDateTime ethbtcTimestamp;

        private PriceBuilder() {
        }

        public PriceBuilder withUsd(BigDecimal ethToUsd) {
            this.ethusd = ethToUsd;
            return this;
        }

        public PriceBuilder withBtc(BigDecimal ethToBtc) {
            this.ethbtc = ethToBtc;
            return this;
        }

        public PriceBuilder withTimestampUsd(LocalDateTime ethToUsdTimestamp) {
            this.ethusdTimestamp = ethToUsdTimestamp;
            return this;
        }

        public PriceBuilder withTimestampBtc(LocalDateTime ethToBtcTimestamp) {
            this.ethbtcTimestamp = ethToBtcTimestamp;
            return this;
        }

        public Price build() {
            Price price = new Price();
            price.ethbtc = this.ethbtc;
            price.ethusd = this.ethusd;
            if (this.ethbtcTimestamp != null) {
                price.ethbtc_timestamp = String.valueOf(this.ethbtcTimestamp.toEpochSecond(ZoneOffset.UTC));
                price._ethbtc_timestamp = this.ethbtcTimestamp;
            }
            if (this.ethusdTimestamp != null) {
                price.ethusd_timestamp = String.valueOf(this.ethusdTimestamp.toEpochSecond(ZoneOffset.UTC));
                price._ethusd_timestamp = this.ethusdTimestamp;
            }
            return price;
        }
    }
}

