/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan;

import io.goodforgod.api.etherscan.AccountAPI;
import io.goodforgod.api.etherscan.BlockAPI;
import io.goodforgod.api.etherscan.ContractAPI;
import io.goodforgod.api.etherscan.Converter;
import io.goodforgod.api.etherscan.EthNetwork;
import io.goodforgod.api.etherscan.EthNetworks;
import io.goodforgod.api.etherscan.EthScanAPIBuilder;
import io.goodforgod.api.etherscan.GasTrackerAPI;
import io.goodforgod.api.etherscan.LogsAPI;
import io.goodforgod.api.etherscan.ProxyAPI;
import io.goodforgod.api.etherscan.StatisticAPI;
import io.goodforgod.api.etherscan.TransactionAPI;
import io.goodforgod.api.etherscan.http.EthHttpClient;
import io.goodforgod.api.etherscan.manager.RequestQueueManager;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public interface EtherScanAPI
extends AutoCloseable {
    @NotNull
    public AccountAPI account();

    @NotNull
    public ContractAPI contract();

    @NotNull
    public TransactionAPI txs();

    @NotNull
    public BlockAPI block();

    @NotNull
    public LogsAPI logs();

    @NotNull
    public ProxyAPI proxy();

    @NotNull
    public StatisticAPI stats();

    @NotNull
    public GasTrackerAPI gasTracker();

    @NotNull
    public static Builder builder() {
        return new EthScanAPIBuilder();
    }

    public static interface Builder {
        @NotNull
        public Builder withApiKey(@NotNull String var1);

        @NotNull
        public Builder withNetwork(@NotNull EthNetwork var1);

        @NotNull
        public Builder withNetwork(@NotNull EthNetworks var1);

        @NotNull
        public Builder withQueue(@NotNull RequestQueueManager var1);

        @NotNull
        public Builder withHttpClient(@NotNull Supplier<EthHttpClient> var1);

        @NotNull
        public Builder withConverter(@NotNull Supplier<Converter> var1);

        @NotNull
        public Builder withRetryOnRateLimit(@Range(from=0L, to=20L) int var1);

        @NotNull
        public EtherScanAPI build();
    }
}

