/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan;

import io.goodforgod.api.etherscan.AccountAPI;
import io.goodforgod.api.etherscan.AccountAPIProvider;
import io.goodforgod.api.etherscan.BlockAPI;
import io.goodforgod.api.etherscan.BlockAPIProvider;
import io.goodforgod.api.etherscan.ContractAPI;
import io.goodforgod.api.etherscan.ContractAPIProvider;
import io.goodforgod.api.etherscan.Converter;
import io.goodforgod.api.etherscan.EthNetwork;
import io.goodforgod.api.etherscan.EtherScanAPI;
import io.goodforgod.api.etherscan.GasTrackerAPI;
import io.goodforgod.api.etherscan.GasTrackerAPIProvider;
import io.goodforgod.api.etherscan.LogsAPI;
import io.goodforgod.api.etherscan.LogsAPIProvider;
import io.goodforgod.api.etherscan.ProxyAPI;
import io.goodforgod.api.etherscan.ProxyAPIProvider;
import io.goodforgod.api.etherscan.StatisticAPI;
import io.goodforgod.api.etherscan.StatisticAPIProvider;
import io.goodforgod.api.etherscan.TransactionAPI;
import io.goodforgod.api.etherscan.TransactionAPIProvider;
import io.goodforgod.api.etherscan.http.EthHttpClient;
import io.goodforgod.api.etherscan.manager.RequestQueueManager;
import org.jetbrains.annotations.NotNull;

final class EtherScanAPIProvider
implements EtherScanAPI {
    private final RequestQueueManager requestQueueManager;
    private final AccountAPI account;
    private final BlockAPI block;
    private final ContractAPI contract;
    private final LogsAPI logs;
    private final ProxyAPI proxy;
    private final StatisticAPI stats;
    private final TransactionAPI txs;
    private final GasTrackerAPI gasTracker;

    EtherScanAPIProvider(String apiKey, EthNetwork network, RequestQueueManager queue, EthHttpClient ethHttpClient, Converter converter, int retryCount) {
        String baseUrl = network.domain() + "?apikey=" + apiKey;
        this.requestQueueManager = queue;
        this.account = new AccountAPIProvider(queue, baseUrl, ethHttpClient, converter, retryCount);
        this.block = new BlockAPIProvider(queue, baseUrl, ethHttpClient, converter, retryCount);
        this.contract = new ContractAPIProvider(queue, baseUrl, ethHttpClient, converter, retryCount);
        this.logs = new LogsAPIProvider(queue, baseUrl, ethHttpClient, converter, retryCount);
        this.proxy = new ProxyAPIProvider(queue, baseUrl, ethHttpClient, converter, retryCount);
        this.stats = new StatisticAPIProvider(queue, baseUrl, ethHttpClient, converter, retryCount);
        this.txs = new TransactionAPIProvider(queue, baseUrl, ethHttpClient, converter, retryCount);
        this.gasTracker = new GasTrackerAPIProvider(queue, baseUrl, ethHttpClient, converter, retryCount);
    }

    @Override
    @NotNull
    public AccountAPI account() {
        return this.account;
    }

    @Override
    @NotNull
    public ContractAPI contract() {
        return this.contract;
    }

    @Override
    @NotNull
    public TransactionAPI txs() {
        return this.txs;
    }

    @Override
    @NotNull
    public BlockAPI block() {
        return this.block;
    }

    @Override
    @NotNull
    public LogsAPI logs() {
        return this.logs;
    }

    @Override
    @NotNull
    public ProxyAPI proxy() {
        return this.proxy;
    }

    @Override
    @NotNull
    public StatisticAPI stats() {
        return this.stats;
    }

    @Override
    @NotNull
    public GasTrackerAPI gasTracker() {
        return this.gasTracker;
    }

    @Override
    public void close() throws Exception {
        this.requestQueueManager.close();
    }
}

