/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan;

import io.goodforgod.api.etherscan.BasicProvider;
import io.goodforgod.api.etherscan.Converter;
import io.goodforgod.api.etherscan.LogsAPI;
import io.goodforgod.api.etherscan.error.EtherScanException;
import io.goodforgod.api.etherscan.http.EthHttpClient;
import io.goodforgod.api.etherscan.manager.RequestQueueManager;
import io.goodforgod.api.etherscan.model.Log;
import io.goodforgod.api.etherscan.model.query.LogQuery;
import io.goodforgod.api.etherscan.model.response.LogResponseTO;
import io.goodforgod.api.etherscan.util.BasicUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class LogsAPIProvider
extends BasicProvider
implements LogsAPI {
    private static final String ACT_LOGS_PARAM = "&action=getLogs";

    LogsAPIProvider(RequestQueueManager queue, String baseUrl, EthHttpClient executor, Converter converter, int retryCount) {
        super(queue, "logs", baseUrl, executor, converter, retryCount);
    }

    @Override
    @NotNull
    public List<Log> logs(@NotNull LogQuery query) throws EtherScanException {
        String urlParams = ACT_LOGS_PARAM + query.params();
        LogResponseTO response = this.getRequest(urlParams, LogResponseTO.class);
        BasicUtils.validateTxResponse(response);
        return BasicUtils.isEmpty(response.getResult()) ? Collections.emptyList() : response.getResult();
    }
}

