/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan;

import com.google.gson.Gson;
import io.goodforgod.api.etherscan.Converter;
import io.goodforgod.api.etherscan.EthNetwork;
import io.goodforgod.api.etherscan.EthNetworks;
import io.goodforgod.api.etherscan.EtherScanAPI;
import io.goodforgod.api.etherscan.EtherScanAPIProvider;
import io.goodforgod.api.etherscan.error.EtherScanKeyException;
import io.goodforgod.api.etherscan.error.EtherScanParseException;
import io.goodforgod.api.etherscan.http.EthHttpClient;
import io.goodforgod.api.etherscan.http.impl.JdkEthHttpClient;
import io.goodforgod.api.etherscan.manager.RequestQueueManager;
import io.goodforgod.api.etherscan.util.BasicUtils;
import io.goodforgod.gson.configuration.GsonConfiguration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class EthScanAPIBuilder
implements EtherScanAPI.Builder {
    private static final Supplier<EthHttpClient> DEFAULT_SUPPLIER = JdkEthHttpClient::new;
    private final Gson gson = new GsonConfiguration().builder().create();
    private int retryCountOnLimitReach = 0;
    private String apiKey;
    private RequestQueueManager queueManager;
    private EthNetwork ethNetwork = EthNetworks.MAINNET;
    private Supplier<EthHttpClient> ethHttpClientSupplier = DEFAULT_SUPPLIER;
    private Supplier<Converter> converterSupplier = () -> new Converter(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @NotNull
        public <T> T fromJson(byte[] jsonAsByteArray, @NotNull Class<T> type) {
            try (InputStreamReader isr = new InputStreamReader(new ByteArrayInputStream(jsonAsByteArray));){
                Object object = EthScanAPIBuilder.this.gson.fromJson((Reader)isr, type);
                return (T)object;
            }
            catch (IOException e) {
                throw new EtherScanParseException(e.getMessage(), e, new String(jsonAsByteArray, StandardCharsets.UTF_8));
            }
        }
    };

    public EthScanAPIBuilder(String apiKey) {
        this.apiKey = apiKey;
    }

    @Override
    @NotNull
    public EtherScanAPI.Builder withApiKey(@NotNull String apiKey) {
        if (BasicUtils.isBlank(apiKey)) {
            throw new EtherScanKeyException("API key can not be null or empty");
        }
        this.apiKey = apiKey;
        return this;
    }

    @Override
    @NotNull
    public EtherScanAPI.Builder withNetwork(@NotNull EthNetwork network) {
        this.ethNetwork = network;
        return this;
    }

    @Override
    @NotNull
    public EtherScanAPI.Builder withNetwork(@NotNull EthNetworks network) {
        this.ethNetwork = network;
        return this;
    }

    @Override
    @NotNull
    public EtherScanAPI.Builder withQueue(@NotNull RequestQueueManager queueManager) {
        this.queueManager = queueManager;
        return this;
    }

    @Override
    @NotNull
    public EtherScanAPI.Builder withHttpClient(@NotNull Supplier<EthHttpClient> httpClientSupplier) {
        this.ethHttpClientSupplier = httpClientSupplier;
        return this;
    }

    @Override
    @NotNull
    public EtherScanAPI.Builder withConverter(@NotNull Supplier<Converter> converterSupplier) {
        this.converterSupplier = converterSupplier;
        return this;
    }

    @Override
    @NotNull
    public EtherScanAPI.Builder withRetryOnRateLimit(int maxRetryCount) {
        if (maxRetryCount < 0 || maxRetryCount > 20) {
            throw new IllegalStateException("maxRetryCount value must be in range from 0 to 20, but was: " + maxRetryCount);
        }
        this.retryCountOnLimitReach = maxRetryCount;
        return this;
    }

    @Override
    @NotNull
    public EtherScanAPI build() {
        RequestQueueManager requestQueueManager = Objects.requireNonNullElseGet(this.queueManager, RequestQueueManager::planFree);
        return new EtherScanAPIProvider(this.apiKey, this.ethNetwork, requestQueueManager, this.ethHttpClientSupplier.get(), this.converterSupplier.get(), this.retryCountOnLimitReach);
    }
}

