/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.http;

import io.goodforgod.api.etherscan.http.EthResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SimpleEthResponse
implements EthResponse {
    private final int statusCode;
    @Nullable
    private final byte[] body;
    private final Map<String, List<String>> headers;

    SimpleEthResponse(int statusCode, @Nullable byte[] body, @Nullable Map<String, List<String>> headers) {
        this.statusCode = statusCode;
        this.body = body;
        this.headers = headers == null ? Collections.emptyMap() : headers;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @Nullable
    public byte[] body() {
        return this.body;
    }

    @Override
    @NotNull
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleEthResponse that = (SimpleEthResponse)o;
        return this.statusCode == that.statusCode && Arrays.equals(this.body, that.body) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        int result = Objects.hash(this.statusCode, this.headers);
        result = 31 * result + Arrays.hashCode(this.body);
        return result;
    }

    public String toString() {
        return "{\"statusCode\": " + this.statusCode + ", \"headers\": " + String.valueOf(this.headers) + ", \"body\": \"" + Arrays.toString(this.body) + "\"}";
    }
}

