/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.model;

import io.goodforgod.api.etherscan.util.BasicUtils;
import java.util.Objects;

public class Abi {
    private final String contractAbi;
    private final boolean isVerified;

    private Abi(String contractAbi, boolean isVerified) {
        this.contractAbi = contractAbi;
        this.isVerified = isVerified;
    }

    public static Abi verified(String contractAbi) {
        return new Abi(contractAbi, true);
    }

    public static Abi nonVerified() {
        return new Abi("", false);
    }

    public boolean haveAbi() {
        return !BasicUtils.isEmpty(this.contractAbi);
    }

    public String getContractAbi() {
        return this.contractAbi;
    }

    public boolean isVerified() {
        return this.isVerified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Abi)) {
            return false;
        }
        Abi abi = (Abi)o;
        return this.isVerified == abi.isVerified && Objects.equals(this.contractAbi, abi.contractAbi);
    }

    public int hashCode() {
        return Objects.hash(this.contractAbi, this.isVerified);
    }

    public String toString() {
        return "Abi{contractAbi=" + this.contractAbi + ", isVerified=" + this.isVerified + "}";
    }

    public static AbiBuilder builder() {
        return new AbiBuilder();
    }

    public static class AbiBuilder {
        private String contractAbi;
        private boolean isVerified;

        private AbiBuilder() {
        }

        public AbiBuilder withContractAbi(String contractAbi) {
            this.contractAbi = contractAbi;
            return this;
        }

        public AbiBuilder withIsVerified(boolean isVerified) {
            this.isVerified = isVerified;
            return this;
        }

        public Abi build() {
            return new Abi(this.contractAbi, this.isVerified);
        }
    }
}

