/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.model;

import io.goodforgod.api.etherscan.model.Wei;
import java.math.BigInteger;
import java.util.Objects;

public class EthSupply {
    private String EthSupply;
    private String Eth2Staking;
    private String BurntFees;
    private String WithdrawnTotal;

    public Wei getEthSupply() {
        return Wei.ofWei(new BigInteger(this.EthSupply));
    }

    public Wei getEth2Staking() {
        return Wei.ofWei(new BigInteger(this.Eth2Staking));
    }

    public Wei getBurntFees() {
        return Wei.ofWei(new BigInteger(this.BurntFees));
    }

    public Wei getTotal() {
        BigInteger total = this.getEthSupply().asWei().add(this.getEth2Staking().asWei()).min(this.getBurntFees().asWei());
        return Wei.ofWei(total);
    }

    public Wei getWithdrawnTotal() {
        return Wei.ofWei(new BigInteger(this.WithdrawnTotal));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EthSupply)) {
            return false;
        }
        EthSupply ethSupply = (EthSupply)o;
        return Objects.equals(this.EthSupply, ethSupply.EthSupply) && Objects.equals(this.Eth2Staking, ethSupply.Eth2Staking) && Objects.equals(this.BurntFees, ethSupply.BurntFees) && Objects.equals(this.WithdrawnTotal, ethSupply.WithdrawnTotal);
    }

    public int hashCode() {
        return Objects.hash(this.EthSupply, this.Eth2Staking, this.BurntFees, this.WithdrawnTotal);
    }

    public String toString() {
        return "EthSupply{EthSupply=" + this.EthSupply + ", Eth2Staking=" + this.Eth2Staking + ", BurntFees=" + this.BurntFees + ", WithdrawnTotal=" + this.WithdrawnTotal + "}";
    }

    public static EthSupplyBuilder builder() {
        return new EthSupplyBuilder();
    }

    public static class EthSupplyBuilder {
        private Wei ethSupply;
        private Wei eth2Staking;
        private Wei burntFees;
        private Wei withdrawnTotal;

        private EthSupplyBuilder() {
        }

        public EthSupplyBuilder withEthSupply(Wei ethSupply) {
            this.ethSupply = ethSupply;
            return this;
        }

        public EthSupplyBuilder withEth2Staking(Wei eth2Staking) {
            this.eth2Staking = eth2Staking;
            return this;
        }

        public EthSupplyBuilder withBurntFees(Wei burntFees) {
            this.burntFees = burntFees;
            return this;
        }

        public EthSupplyBuilder withWithdrawnTotal(Wei withdrawnTotal) {
            this.withdrawnTotal = withdrawnTotal;
            return this;
        }

        public EthSupply build() {
            EthSupply ethSupply = new EthSupply();
            ethSupply.BurntFees = this.burntFees != null ? this.burntFees.toString() : BigInteger.ZERO.toString();
            ethSupply.Eth2Staking = this.eth2Staking != null ? this.eth2Staking.toString() : BigInteger.ZERO.toString();
            ethSupply.EthSupply = this.ethSupply != null ? this.ethSupply.toString() : BigInteger.ZERO.toString();
            ethSupply.WithdrawnTotal = this.withdrawnTotal != null ? this.withdrawnTotal.toString() : BigInteger.ZERO.toString();
            return ethSupply;
        }
    }
}

