/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.model;

import io.goodforgod.api.etherscan.model.BlockTx;
import io.goodforgod.api.etherscan.model.Wei;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Objects;

public class TxErc20
extends BlockTx {
    private BigInteger value;
    private String tokenName;
    private String tokenSymbol;
    private String tokenDecimal;

    protected TxErc20() {
    }

    public BigInteger getValue() {
        return this.value;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public String getTokenSymbol() {
        return this.tokenSymbol;
    }

    public String getTokenDecimal() {
        return this.tokenDecimal;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TxErc20)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TxErc20 txErc20 = (TxErc20)o;
        return Objects.equals(this.tokenName, txErc20.tokenName) && Objects.equals(this.tokenSymbol, txErc20.tokenSymbol) && Objects.equals(this.tokenDecimal, txErc20.tokenDecimal);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tokenName, this.tokenSymbol, this.tokenDecimal);
    }

    public String toString() {
        return "TxErc20{value=" + String.valueOf(this.value) + ", tokenName=" + this.tokenName + ", tokenSymbol=" + this.tokenSymbol + ", tokenDecimal=" + this.tokenDecimal + ", nonce=" + this.nonce + ", blockHash=" + this.blockHash + ", transactionIndex=" + this.transactionIndex + ", confirmations=" + this.confirmations + ", gasPrice=" + String.valueOf(this.gasPrice) + ", cumulativeGasUsed=" + String.valueOf(this.cumulativeGasUsed) + ", blockNumber=" + this.blockNumber + ", timeStamp=" + this.timeStamp + ", hash=" + this.hash + ", from=" + this.from + ", to=" + this.to + ", contractAddress=" + this.contractAddress + ", input=" + this.input + ", gas=" + String.valueOf(this.gas) + ", gasUsed=" + String.valueOf(this.gasUsed) + "}";
    }

    public static TxERC20Builder builder() {
        return new TxERC20Builder();
    }

    public static class TxERC20Builder {
        private long blockNumber;
        private LocalDateTime timeStamp;
        private String hash;
        private String from;
        private String to;
        private BigInteger value;
        private String contractAddress;
        private String input;
        private Wei gas;
        private Wei gasUsed;
        private long nonce;
        private String blockHash;
        private String tokenName;
        private String tokenSymbol;
        private String tokenDecimal;
        private int transactionIndex;
        private Wei gasPrice;
        private Wei cumulativeGasUsed;
        private long confirmations;

        private TxERC20Builder() {
        }

        public TxERC20Builder withBlockNumber(long blockNumber) {
            this.blockNumber = blockNumber;
            return this;
        }

        public TxERC20Builder withTimeStamp(LocalDateTime timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public TxERC20Builder withHash(String hash) {
            this.hash = hash;
            return this;
        }

        public TxERC20Builder withFrom(String from) {
            this.from = from;
            return this;
        }

        public TxERC20Builder withTo(String to) {
            this.to = to;
            return this;
        }

        public TxERC20Builder withValue(BigInteger value) {
            this.value = value;
            return this;
        }

        public TxERC20Builder withContractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
            return this;
        }

        public TxERC20Builder withInput(String input) {
            this.input = input;
            return this;
        }

        public TxERC20Builder withGas(Wei gas) {
            this.gas = gas;
            return this;
        }

        public TxERC20Builder withGasUsed(Wei gasUsed) {
            this.gasUsed = gasUsed;
            return this;
        }

        public TxERC20Builder withNonce(long nonce) {
            this.nonce = nonce;
            return this;
        }

        public TxERC20Builder withBlockHash(String blockHash) {
            this.blockHash = blockHash;
            return this;
        }

        public TxERC20Builder withTokenName(String tokenName) {
            this.tokenName = tokenName;
            return this;
        }

        public TxERC20Builder withTokenSymbol(String tokenSymbol) {
            this.tokenSymbol = tokenSymbol;
            return this;
        }

        public TxERC20Builder withTokenDecimal(String tokenDecimal) {
            this.tokenDecimal = tokenDecimal;
            return this;
        }

        public TxERC20Builder withTransactionIndex(int transactionIndex) {
            this.transactionIndex = transactionIndex;
            return this;
        }

        public TxERC20Builder withGasPrice(Wei gasPrice) {
            this.gasPrice = gasPrice;
            return this;
        }

        public TxERC20Builder withCumulativeGasUsed(Wei cumulativeGasUsed) {
            this.cumulativeGasUsed = cumulativeGasUsed;
            return this;
        }

        public TxERC20Builder withConfirmations(long confirmations) {
            this.confirmations = confirmations;
            return this;
        }

        public TxErc20 build() {
            TxErc20 txERC20 = new TxErc20();
            txERC20.tokenName = this.tokenName;
            txERC20.hash = this.hash;
            if (this.gas != null) {
                txERC20.gas = this.gas.asWei();
            }
            if (this.gasUsed != null) {
                txERC20.gasUsed = this.gasUsed.asWei();
            }
            if (this.gasPrice != null) {
                txERC20.gasPrice = this.gasPrice.asWei();
            }
            if (this.cumulativeGasUsed != null) {
                txERC20.cumulativeGasUsed = this.cumulativeGasUsed.asWei();
            }
            txERC20.from = this.from;
            txERC20.tokenSymbol = this.tokenSymbol;
            txERC20.transactionIndex = this.transactionIndex;
            txERC20.contractAddress = this.contractAddress;
            txERC20.nonce = this.nonce;
            txERC20.confirmations = this.confirmations;
            txERC20.value = this.value;
            if (this.timeStamp != null) {
                txERC20.timeStamp = String.valueOf(this.timeStamp.toEpochSecond(ZoneOffset.UTC));
                txERC20._timeStamp = this.timeStamp;
            }
            txERC20.blockHash = this.blockHash;
            txERC20.blockNumber = this.blockNumber;
            txERC20.to = this.to;
            txERC20.input = this.input;
            txERC20.tokenDecimal = this.tokenDecimal;
            return txERC20;
        }
    }
}

